/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference.graph;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.MethodInstantiationUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0002J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraph;", "", "units", "", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitNode;", "<init>", "(Ljava/util/List;)V", "getUnits", "()Ljava/util/List;", "dependsOnNode", "", "type", "Lcom/intellij/psi/PsiType;", "resolveOrder", "visitTypes", "", "unit", "visited", "", "order", "", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nInferenceUnitGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferenceUnitGraph.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,270:1\n1563#2:271\n1634#2,3:272\n1#3:275\n13805#4,2:276\n*S KotlinDebug\n*F\n+ 1 InferenceUnitGraph.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraph\n*L\n19#1:271\n19#1:272,3\n46#1:276,2\n*E\n"})
public final class InferenceUnitGraph {
    @NotNull
    private final List<InferenceUnitNode> units;

    public InferenceUnitGraph(@NotNull List<InferenceUnitNode> units) {
        Intrinsics.checkNotNullParameter(units, (String)"units");
        this.units = units;
    }

    @NotNull
    public final List<InferenceUnitNode> getUnits() {
        return this.units;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean dependsOnNode(@NotNull PsiType type) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable $this$map$iv = this.units;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InferenceUnitNode inferenceUnitNode = (InferenceUnitNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCore().getType());
        }
        return CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)type);
    }

    @NotNull
    public final List<InferenceUnitNode> resolveOrder() {
        Set visited = new LinkedHashSet();
        List order = new ArrayList();
        for (InferenceUnitNode unit : this.units) {
            this.visitTypes(unit, visited, order);
        }
        return order;
    }

    /*
     * WARNING - void declaration
     */
    private final void visitTypes(InferenceUnitNode unit, Set<InferenceUnitNode> visited, List<InferenceUnitNode> order) {
        void $this$forEach$iv;
        PsiType[] psiTypeArray;
        Object v0;
        block10: {
            if (visited.contains(unit)) {
                return;
            }
            visited.add(unit);
            Iterable iterable = this.units;
            for (Object t : iterable) {
                InferenceUnitNode it = (InferenceUnitNode)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)unit.getTypeInstantiation())) continue;
                v0 = t;
                break block10;
            }
            v0 = null;
        }
        InferenceUnitNode inferenceUnitNode = v0;
        if (inferenceUnitNode != null) {
            InferenceUnitNode $this$visitTypes_u24lambda_u241 = inferenceUnitNode;
            boolean bl = false;
            this.visitTypes($this$visitTypes_u24lambda_u241, visited, order);
        }
        PsiType[] flushedType = MethodInstantiationUtilKt.removeWildcard(unit.getTypeInstantiation());
        if (flushedType instanceof PsiClassType) {
            PsiType[] psiTypeArray2 = ((PsiClassType)flushedType).getParameters();
            psiTypeArray = psiTypeArray2;
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray2, (String)"getParameters(...)");
        } else if (flushedType instanceof PsiIntersectionType) {
            PsiType[] psiTypeArray3 = ((PsiIntersectionType)flushedType).getConjuncts();
            psiTypeArray = psiTypeArray3;
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray3, (String)"getConjuncts(...)");
        } else {
            psiTypeArray = new PsiType[]{};
        }
        flushedType = psiTypeArray;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int j = 0; j < n; ++j) {
            InferenceUnitNode $this$visitTypes_u24lambda_u242_u241;
            Object v5;
            block11: {
                void element$iv;
                void parameter = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                Iterable iterable = this.units;
                for (Object t : iterable) {
                    InferenceUnitNode it = (InferenceUnitNode)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)parameter)) continue;
                    v5 = t;
                    break block11;
                }
                v5 = null;
            }
            if ((InferenceUnitNode)v5 == null) continue;
            boolean bl = false;
            this.visitTypes($this$visitTypes_u24lambda_u242_u241, visited, order);
        }
        InferenceUnitNode parent = unit.getParent();
        if (parent != null) {
            this.visitTypes(parent, visited, order);
        }
        order.add(unit);
    }

    @NotNull
    public final List<InferenceUnitNode> component1() {
        return this.units;
    }

    @NotNull
    public final InferenceUnitGraph copy(@NotNull List<InferenceUnitNode> units) {
        Intrinsics.checkNotNullParameter(units, (String)"units");
        return new InferenceUnitGraph(units);
    }

    public static /* synthetic */ InferenceUnitGraph copy$default(InferenceUnitGraph inferenceUnitGraph, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = inferenceUnitGraph.units;
        }
        return inferenceUnitGraph.copy(list);
    }

    @NotNull
    public String toString() {
        return "InferenceUnitGraph(units=" + this.units + ")";
    }

    public int hashCode() {
        return ((Object)this.units).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InferenceUnitGraph)) {
            return false;
        }
        InferenceUnitGraph inferenceUnitGraph = (InferenceUnitGraph)other;
        return Intrinsics.areEqual(this.units, inferenceUnitGraph.units);
    }
}

