/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public class GrTypeParameterListImpl
extends GrStubElementBase<EmptyStub>
implements GrTypeParameterList,
StubBasedPsiElement<EmptyStub>,
PsiListLikeElement {
    public GrTypeParameterListImpl(EmptyStub stub) {
        super(stub, (IStubElementType)GroovyEmptyStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public GrTypeParameterListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "Type parameter list";
    }

    @Override
    public GrTypeParameter @NotNull [] getTypeParameters() {
        GrTypeParameter[] grTypeParameterArray = (GrTypeParameter[])this.getStubOrPsiChildren(GroovyStubElementTypes.TYPE_PARAMETER, GrTypeParameter.ARRAY_FACTORY);
        if (grTypeParameterArray == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(1);
        }
        return grTypeParameterArray;
    }

    public int getTypeParameterIndex(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(2);
        }
        GrTypeParameter[] typeParameters = this.getTypeParameters();
        for (int i2 = 0; i2 < typeParameters.length; ++i2) {
            if (!typeParameters[i2].equals(typeParameter)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(3);
        }
        visitor2.visitTypeParameterList(this);
    }

    public PsiElement add(@NotNull PsiElement element) {
        if (element == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiTypeParameter)) {
            return super.add(element);
        }
        return this.addInternal(element.getNode(), element.getNode(), null, true).getPsi();
    }

    public ASTNode addInternal(@NotNull ASTNode first, @NotNull ASTNode last, ASTNode anchor, Boolean before) {
        if (first == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(5);
        }
        if (last == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(6);
        }
        this.appendParenthesesIfNeeded();
        if (first == last && first.getPsi() instanceof PsiTypeParameter) {
            boolean hasParams;
            boolean bl = hasParams = this.getTypeParameters().length > 0;
            ASTNode _anchor = anchor == null ? (before.booleanValue() ? this.getLastChild().getNode() : this.getFirstChild().getNode()) : anchor;
            ASTNode node = super.addInternal(first, last, _anchor, before);
            if (hasParams) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor != null ? anchor : node);
            }
            return node;
        }
        return super.addInternal(first, last, anchor, before);
    }

    private void appendParenthesesIfNeeded() {
        GrModifierList list;
        PsiElement[] modifiers;
        PsiElement parent;
        PsiElement last;
        PsiElement first = this.getFirstChild();
        if (first == null) {
            this.getNode().addLeaf(GroovyTokenTypes.mLT, (CharSequence)"<", null);
        }
        if ((last = this.getLastChild()).getNode().getElementType() != GroovyTokenTypes.mGT) {
            this.getNode().addLeaf(GroovyTokenTypes.mGT, (CharSequence)">", null);
        }
        if ((parent = this.getParent()) instanceof GrMethod && (modifiers = (list = ((GrMethod)parent).getModifierList()).getModifiers()).length == 0) {
            list.setModifierProperty("def", true);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(9);
        }
        if (!ResolveUtilKt.shouldProcessTypeParameters(processor)) {
            return true;
        }
        for (GrTypeParameter typeParameter : this.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<GrTypeParameter> list = Arrays.asList(this.getTypeParameters());
        if (list == null) {
            GrTypeParameterListImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrTypeParameterListImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/types/GrTypeParameterListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterIndex";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInternal";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10 -> new IllegalStateException(string);
        };
    }
}

