/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.typeann;

import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;

public interface TargetInfo {

    public static class TypeArgumentTarget
    implements TargetInfo {
        private final int offset;
        private final int typeArgumentIndex;

        public TypeArgumentTarget(int offset, int typeArgumentIndex) {
            this.offset = offset;
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getTypeArgumentIndex() {
            return this.typeArgumentIndex;
        }
    }

    public static class TypeParameterBoundTarget
    implements TargetInfo {
        private final int typeParameterIndex;
        private final int boundIndex;

        public TypeParameterBoundTarget(int typeParameterIndex, int boundIndex) {
            this.typeParameterIndex = typeParameterIndex;
            this.boundIndex = boundIndex;
        }

        public int getTypeParameterIndex() {
            return this.typeParameterIndex;
        }

        public int getBoundIndex() {
            return this.boundIndex;
        }

        public static List<TypeAnnotation> extract(List<TypeAnnotation> typeAnnotations, int typeParameterIndex, int boundIndex) {
            return typeAnnotations.stream().filter(typeAnnotation -> {
                TargetInfo targetInfo = typeAnnotation.getTargetInfo();
                return targetInfo instanceof TypeParameterBoundTarget && ((TypeParameterBoundTarget)targetInfo).getTypeParameterIndex() == typeParameterIndex && ((TypeParameterBoundTarget)targetInfo).getBoundIndex() == boundIndex;
            }).collect(Collectors.toList());
        }
    }

    public static class TypeParameterTarget
    implements TargetInfo {
        private final int typeParameterIndex;

        public TypeParameterTarget(int typeParameterIndex) {
            this.typeParameterIndex = typeParameterIndex;
        }

        public int getTypeParameterIndex() {
            return this.typeParameterIndex;
        }

        public static List<TypeAnnotation> extract(List<TypeAnnotation> typeAnnotations, int typeParameterIndex) {
            return typeAnnotations.stream().filter(typeAnnotation -> {
                TargetInfo targetInfo = typeAnnotation.getTargetInfo();
                return targetInfo instanceof TypeParameterTarget && ((TypeParameterTarget)targetInfo).getTypeParameterIndex() == typeParameterIndex;
            }).collect(Collectors.toList());
        }
    }

    public static class ThrowsTarget
    implements TargetInfo {
        private final int throwsTypeIndex;

        public ThrowsTarget(int throwsTypeIndex) {
            this.throwsTypeIndex = throwsTypeIndex;
        }

        public int getThrowsTypeIndex() {
            return this.throwsTypeIndex;
        }

        public static List<TypeAnnotation> extract(List<TypeAnnotation> typeAnnotations, int throwsTypeIndex) {
            return typeAnnotations.stream().filter(typeAnnotation -> {
                TargetInfo targetInfo = typeAnnotation.getTargetInfo();
                return targetInfo instanceof ThrowsTarget && ((ThrowsTarget)targetInfo).getThrowsTypeIndex() == throwsTypeIndex;
            }).collect(Collectors.toList());
        }
    }

    public static class SupertypeTarget
    implements TargetInfo {
        private static final int EXTENDS_CLAUSE_INDEX = 65535;
        private final int supertypeIndex;

        public SupertypeTarget(int supertypeIndex) {
            this.supertypeIndex = supertypeIndex;
        }

        public int getSupertypeIndex() {
            return this.supertypeIndex;
        }

        public boolean inExtendsClause() {
            return this.supertypeIndex == 65535;
        }

        public static List<TypeAnnotation> extract(List<TypeAnnotation> typeAnnotations, int superTypeIndex) {
            return typeAnnotations.stream().filter(typeAnnotation -> {
                TargetInfo targetInfo = typeAnnotation.getTargetInfo();
                return targetInfo instanceof SupertypeTarget && ((SupertypeTarget)targetInfo).getSupertypeIndex() == superTypeIndex;
            }).collect(Collectors.toList());
        }

        public static List<TypeAnnotation> extractExtends(List<TypeAnnotation> typeAnnotations) {
            return typeAnnotations.stream().filter(typeAnnotation -> {
                TargetInfo targetInfo = typeAnnotation.getTargetInfo();
                return targetInfo instanceof SupertypeTarget && ((SupertypeTarget)targetInfo).inExtendsClause();
            }).collect(Collectors.toList());
        }
    }

    public static class OffsetTarget
    implements TargetInfo {
        private final int offset;

        public OffsetTarget(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class LocalvarTarget
    implements TargetInfo {
        private final Offsets[] table;

        public LocalvarTarget(Offsets[] table) {
            this.table = table;
        }

        public Offsets[] getTable() {
            return this.table;
        }

        public static class Offsets {
            private final int startPc;
            private final int length;
            private final int index;

            public Offsets(int startPc, int length, int index) {
                this.startPc = startPc;
                this.length = length;
                this.index = index;
            }

            public int getStartPc() {
                return this.startPc;
            }

            public int getLength() {
                return this.length;
            }

            public int getIndex() {
                return this.index;
            }
        }
    }

    public static class FormalParameterTarget
    implements TargetInfo {
        private final int formalParameterIndex;

        public FormalParameterTarget(int formalParameterIndex) {
            this.formalParameterIndex = formalParameterIndex;
        }

        public int getFormalParameterIndex() {
            return this.formalParameterIndex;
        }

        public static List<TypeAnnotation> extract(List<TypeAnnotation> typeAnnotations) {
            return typeAnnotations.stream().filter(typeAnnotation -> typeAnnotation.getTargetInfo() instanceof FormalParameterTarget).collect(Collectors.toList());
        }

        public static List<TypeAnnotation> extract(List<TypeAnnotation> typeAnnotations, int formalParameterIndex) {
            return typeAnnotations.stream().filter(typeAnnotation -> {
                TargetInfo targetInfo = typeAnnotation.getTargetInfo();
                return targetInfo instanceof FormalParameterTarget && ((FormalParameterTarget)targetInfo).getFormalParameterIndex() == formalParameterIndex;
            }).collect(Collectors.toList());
        }
    }

    public static class EmptyTarget
    implements TargetInfo {
        public static List<TypeAnnotation> extract(List<TypeAnnotation> typeAnnotations) {
            return typeAnnotations.stream().filter(typeAnnotation -> typeAnnotation.getTargetInfo() instanceof EmptyTarget).collect(Collectors.toList());
        }
    }

    public static class CatchTarget
    implements TargetInfo {
        private final int exceptionTableIndex;

        public CatchTarget(int exceptionTableIndex) {
            this.exceptionTableIndex = exceptionTableIndex;
        }

        public int getExceptionTableIndex() {
            return this.exceptionTableIndex;
        }
    }
}

