/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.common.Argument;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class Valence {
    public final List<Argument> arguments;

    public Valence(List<Argument> arguments) {
        this.arguments = arguments;
    }

    public Valence append(Argument argument) {
        return new Valence(((StreamEx)StreamEx.of(this.arguments).append((Object)argument).distinct()).toList());
    }

    public Valence withoutArg(Argument argument) {
        return new Valence(((StreamEx)StreamEx.of(this.arguments).filter(a -> !a.equals(argument))).toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Valence)) return false;
        Valence structure = (Valence)o;
        if (!this.arguments.equals(structure.arguments)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.arguments);
    }

    public String toString() {
        return StreamEx.of(this.arguments).joining((CharSequence)"+");
    }

    public boolean hasAnyArgument(Node head, NodePattern adjunct) {
        return this.arguments.stream().map(a -> a.findOn(head)).anyMatch(arg -> arg != null && !adjunct.matches((Node)arg));
    }

    public boolean hasAllObligatoryArguments(Node node) {
        return this.hasAllObligatoryArguments(node, null);
    }

    public boolean hasAllArguments(Node node) {
        return this.all(a -> a.findOn(node) != null);
    }

    public boolean hasAllObligatoryArguments(Node node, @Nullable Argument toIgnore) {
        return this.all(a -> !a.isObligatory() || a.equals(toIgnore) || a.findOn(node) != null);
    }

    public boolean hasAnyArgument(Set<String> argStrings) {
        return this.any(a -> argStrings.contains(a.presentable));
    }

    public boolean recognizesArgument(Node arg) {
        return this.any(a -> a.matchesFully(arg));
    }

    public boolean has(String argString) {
        return this.any(a -> argString.equals(a.presentable));
    }

    public boolean any(Predicate<Argument> condition) {
        return this.arguments.stream().anyMatch(condition);
    }

    public boolean all(Predicate<Argument> condition) {
        return this.arguments.stream().allMatch(condition);
    }
}

