/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/fixers/KotlinMissingWhenEntryBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "<init>", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "intellij.kotlin.base.codeInsight.minimal"})
public final class KotlinMissingWhenEntryBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof KtWhenEntry) || ((KtWhenEntry)element).getExpression() != null) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiElement arrow = ((KtWhenEntry)element).getArrow();
        if (arrow != null) {
            doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(arrow)), (CharSequence)"{\n}");
        } else {
            KtWhenCondition[] ktWhenConditionArray = ((KtWhenEntry)element).getConditions();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
            KtWhenCondition ktWhenCondition = (KtWhenCondition)ArraysKt.lastOrNull((Object[])ktWhenConditionArray);
            if (ktWhenCondition == null) {
                return;
            }
            KtWhenCondition lastCondition = ktWhenCondition;
            if (PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)lastCondition), PsiErrorElement.class) != null) {
                return;
            }
            int offset = FixersUtilKt.getEnd(FixersUtilKt.getRange((PsiElement)lastCondition));
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            if (doc.getLineNumber(caretModel2.getOffset()) == doc.getLineNumber(FixersUtilKt.getStart(FixersUtilKt.getRange(element)))) {
                caretModel2.moveToOffset(offset);
            }
            doc.insertString(offset, (CharSequence)"-> {\n}");
        }
    }
}

