/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.editor.KotlinEnterAfterUnmatchedBraceHandlerKt;
import org.jetbrains.kotlin.idea.editor.KotlinEnterHandlerKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J4\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "preprocessEnterInStringLiteral", "", "psiFile", "caretAdvanceRef", "Companion", "intellij.kotlin.base.codeInsight.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinEnterHandler\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,128:1\n249#2:129\n*S KotlinDebug\n*F\n+ 1 KotlinEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinEnterHandler\n*L\n107#1:129\n*E\n"})
public final class KotlinEnterHandler
implements EnterHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final TokenSet FORCE_INDENT_IN_LAMBDA_AFTER;

    /*
     * Unable to fully structure code
     */
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.preprocessEnterInStringLiteral(file, editor, caretOffsetRef, caretAdvance)) {
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        v0 = CodeInsightSettings.getInstance();
        Intrinsics.checkNotNull((Object)v0);
        if (!v0.SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        v1 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDocument(...)");
        document = v1;
        v2 = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getCharsSequence(...)");
        text = v2;
        v3 = caretOffsetRef.get();
        Intrinsics.checkNotNull((Object)v3);
        caretOffset = ((Number)v3).intValue();
        if (!(0 <= caretOffset ? caretOffset <= text.length() : false)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        elementAt = file.findElementAt(caretOffset);
        if (elementAt instanceof PsiWhiteSpace && ((PsiWhiteSpace)elementAt).textContains('\n')) {
            return EnterHandlerDelegate.Result.Continue;
        }
        elementBefore = KotlinEnterAfterUnmatchedBraceHandlerKt.getElementAtOffsetIgnoreWhitespaceAfter(file, caretOffset);
        elementAfter = KotlinEnterHandlerKt.getElementAtOffsetIgnoreWhitespaceBefore(file, caretOffset);
        if (elementBefore == null) ** GOTO lbl-1000
        v4 = elementBefore.getNode();
        Intrinsics.checkNotNull((Object)v4);
        if (KotlinEnterHandler.FORCE_INDENT_IN_LAMBDA_AFTER.contains(v4.getElementType())) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = isAfterLBraceOrArrow = false;
        }
        if (elementAfter == null) ** GOTO lbl-1000
        v6 = elementAfter.getNode();
        Intrinsics.checkNotNull((Object)v6);
        if (Intrinsics.areEqual((Object)v6.getElementType(), (Object)KtTokens.RBRACE)) {
            v7 = true;
        } else lbl-1000:
        // 2 sources

        {
            v7 = isBeforeRBrace = false;
        }
        if (isAfterLBraceOrArrow && isBeforeRBrace) {
            v8 = elementBefore;
            Intrinsics.checkNotNull((Object)v8);
            if (v8.getParent() instanceof KtFunctionLiteral) {
                v9 = originalHandler;
                if (v9 != null) {
                    v9.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
                }
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                try {
                    v10 = CodeStyleManager.getInstance((Project)file.getProject());
                    Intrinsics.checkNotNull((Object)v10);
                    v10.adjustLineIndent(file, editor.getCaretModel().getOffset());
                }
                catch (IncorrectOperationException e) {
                    KotlinEnterHandler.LOG.error((Throwable)e);
                }
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private final boolean preprocessEnterInStringLiteral(PsiFile psiFile, Editor editor, Ref<Integer> caretOffsetRef, Ref<Integer> caretAdvanceRef) {
        PsiElement psiAtOffset;
        Integer caretOffset = (Integer)caretOffsetRef.get();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(doc);
        Integer n = caretOffset;
        Intrinsics.checkNotNull((Object)n);
        PsiElement psiElement = psiFile.findElementAt(((Number)n).intValue());
        if (psiElement == null) {
            return false;
        }
        PsiElement $this$getStrictParentOfType$iv = psiAtOffset = psiElement;
        boolean $i$f$getStrictParentOfType = false;
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtStringTemplateExpression.class, (boolean)true);
        if (ktStringTemplateExpression == null) {
            return false;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        if (!KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)stringTemplate)) {
            return false;
        }
        n = psiAtOffset.getNode().getElementType();
        if (Intrinsics.areEqual((Object)n, (Object)KtTokens.CLOSING_QUOTE) || Intrinsics.areEqual((Object)n, (Object)KtTokens.REGULAR_STRING_PART) || Intrinsics.areEqual((Object)n, (Object)KtTokens.ESCAPE_SEQUENCE) || Intrinsics.areEqual((Object)n, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)n, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
            int caretAdvance = 1;
            if (stringTemplate.getParent() instanceof KtDotQualifiedExpression) {
                doc.insertString(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)stringTemplate)), (CharSequence)")");
                doc.insertString(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)stringTemplate)), (CharSequence)"(");
                Integer n2 = caretOffset;
                caretOffset = n2 + 1;
                ++caretAdvance;
            }
            Integer n3 = caretOffset;
            Intrinsics.checkNotNull((Object)n3);
            doc.insertString(((Number)n3).intValue(), (CharSequence)"\" + \"");
            caretOffsetRef.set((Object)(caretOffset + 3));
            caretAdvanceRef.set((Object)caretAdvance);
            return true;
        }
        return false;
    }

    static {
        Logger logger = Logger.getInstance(KotlinEnterHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.ARROW, KtTokens.LBRACE};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        FORCE_INDENT_IN_LAMBDA_AFTER = tokenSet;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEnterHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "FORCE_INDENT_IN_LAMBDA_AFTER", "Lcom/intellij/psi/tree/TokenSet;", "intellij.kotlin.base.codeInsight.minimal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

