/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import git4idea.branch.GitRebaseParams;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitAutomaticRebaseEditor;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.log.GitCommitEditingOperation;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.repo.GitRepository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f0\u0007\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/rebase/GitRewordOperation;", "Lgit4idea/rebase/log/GitCommitEditingOperation;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "newMessage", "", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "initialHeadPosition", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/Nullable;", "execute", "Lgit4idea/rebase/log/GitCommitEditingOperationResult;", "canRewordViaAmend", "", "isLatestCommit", "rewordViaRebase", "rewordViaAmend", "injectRewordAction", "", "Lgit4idea/rebase/GitRebaseEntry;", "list", "supplyNewMessage", "editorText", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRewordOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRewordOperation.kt\ngit4idea/rebase/GitRewordOperation\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n13#2:106\n1563#3:107\n1634#3,3:108\n*S KotlinDebug\n*F\n+ 1 GitRewordOperation.kt\ngit4idea/rebase/GitRewordOperation\n*L\n31#1:106\n88#1:107\n88#1:108,3\n*E\n"})
public final class GitRewordOperation
extends GitCommitEditingOperation {
    @NotNull
    private final VcsCommitMetadata commit;
    @NotNull
    private final String newMessage;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final String initialHeadPosition;

    public GitRewordOperation(@NotNull GitRepository repository2, @NotNull VcsCommitMetadata commit, @NotNull String newMessage) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
        super(repository2);
        this.commit = commit;
        this.newMessage = newMessage;
        repository2.update();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRewordOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        String string = repository2.getCurrentRevision();
        Intrinsics.checkNotNull((Object)string);
        this.initialHeadPosition = string;
    }

    @NotNull
    public final GitCommitEditingOperationResult execute() {
        GitCommitEditingOperationResult operationResult2;
        if (this.canRewordViaAmend() && (operationResult2 = this.rewordViaAmend()) instanceof GitCommitEditingOperationResult.Complete) {
            return operationResult2;
        }
        return this.rewordViaRebase();
    }

    private final boolean canRewordViaAmend() {
        return this.isLatestCommit() && GitVersionSpecialty.CAN_AMEND_WITHOUT_FILES.existsIn(this.getProject());
    }

    private final boolean isLatestCommit() {
        return Intrinsics.areEqual((Object)((Hash)this.commit.getId()).asString(), (Object)this.initialHeadPosition);
    }

    private final GitCommitEditingOperationResult rewordViaRebase() {
        Project project = this.getProject();
        VirtualFile virtualFile = this.commit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        GitAutomaticRebaseEditor rebaseEditor = new GitAutomaticRebaseEditor(project, virtualFile, (Function1<? super List<? extends GitRebaseEntry>, ? extends List<? extends GitRebaseEntry>>)((Function1)arg_0 -> GitRewordOperation.rewordViaRebase$lambda$0(this, arg_0)), (Function1<? super String, String>)((Function1)arg_0 -> GitRewordOperation.rewordViaRebase$lambda$1(this, arg_0)));
        return GitCommitEditingOperation.rebase$default(this, CollectionsKt.listOf((Object)this.commit), rebaseEditor, false, null, 12, null);
    }

    private final GitCommitEditingOperationResult rewordViaAmend() {
        GitLineHandler handler = new GitLineHandler(this.getProject(), this.getRepository().getRoot(), GitCommand.COMMIT);
        File messageFile = null;
        try {
            Project project = this.getProject();
            VirtualFile virtualFile = this.getRepository().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            messageFile = GitCheckinEnvironment.Companion.createCommitMessageFile(project, virtualFile, this.newMessage);
        }
        catch (IOException e) {
            this.LOG.warn("Couldn't create message file", (Throwable)e);
            return GitCommitEditingOperationResult.Incomplete.INSTANCE;
        }
        String[] e = new String[]{"--amend"};
        handler.addParameters(e);
        e = new String[]{"-F"};
        handler.addParameters(e);
        handler.addAbsoluteFile(messageFile);
        e = new String[]{"--only"};
        handler.addParameters(e);
        e = new String[]{"--no-verify"};
        handler.addParameters(e);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        this.getRepository().update();
        if (result2.success()) {
            GitRebaseParams.RebaseUpstream upstream = GitInteractiveRebaseUsingLogKt.getRebaseUpstreamFor((VcsShortCommitDetails)this.commit);
            GitRepository gitRepository = this.getRepository();
            String string = this.getRepository().getCurrentRevision();
            Intrinsics.checkNotNull((Object)string);
            return new GitCommitEditingOperationResult.Complete(gitRepository, upstream, this.initialHeadPosition, string, null, null, 48, null);
        }
        this.LOG.warn("Couldn't reword via amend: " + result2.getErrorOutputAsJoinedString());
        return GitCommitEditingOperationResult.Incomplete.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final List<GitRebaseEntry> injectRewordAction(List<? extends GitRebaseEntry> list) {
        $this$map$iv = list;
        $i$f$map = false;
        var4_4 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var9_9 = (GitRebaseEntry)item$iv$iv;
            var11_11 = destination$iv$iv;
            $i$a$-map-GitRewordOperation$injectRewordAction$1 = false;
            if (!Intrinsics.areEqual((Object)entry.getAction(), (Object)GitRebaseEntry.Action.PICK.INSTANCE)) ** GOTO lbl-1000
            v0 = ((Hash)this.commit.getId()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"asString(...)");
            if (StringsKt.startsWith$default((String)v0, (String)entry.getCommit(), (boolean)false, (int)2, null)) {
                v1 = new GitRebaseEntry(GitRebaseEntry.Action.REWORD.INSTANCE, entry.getCommit(), entry.getSubject());
            } else lbl-1000:
            // 2 sources

            {
                v1 = entry;
            }
            var11_11.add(v1);
        }
        return (List)destination$iv$iv;
    }

    private final String supplyNewMessage(String editorText) {
        String string = this.commit.getFullMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullMessage(...)");
        if (StringsKt.startsWith$default((String)editorText, (String)string, (boolean)false, (int)2, null)) {
            return this.newMessage;
        }
        Attachment[] attachmentArray = new Attachment[]{new Attachment("actual.txt", editorText), new Attachment("expected.txt", this.commit.getFullMessage())};
        this.LOG.error("Unexpected editor content. Charset: " + GitConfigUtil.getCommitEncodingCharset(this.getProject(), this.commit.getRoot()), attachmentArray);
        throw new IllegalStateException("Unexpected editor content");
    }

    private static final List rewordViaRebase$lambda$0(GitRewordOperation this$0, List list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        return this$0.injectRewordAction(list);
    }

    private static final String rewordViaRebase$lambda$1(GitRewordOperation this$0, String editorText) {
        Intrinsics.checkNotNullParameter((Object)editorText, (String)"editorText");
        return this$0.supplyNewMessage(editorText);
    }
}

