/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.EnumEntryVsCompanionPriorityCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\r*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u001c\u0010\u0013\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CustomEnumEntriesMigrationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isExtensionWithEnumClassQualifier", "", "isCallViaCompanionOnEnumClassQualifier", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isCallToExternalEntriesInsideEnum", "contextExpression", "isReferenceToMemberEntriesWithoutExpectedFunctionalType", "expression", "frontend"})
@SourceDebugExtension(value={"SMAP\nCustomEnumEntriesMigrationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomEnumEntriesMigrationCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CustomEnumEntriesMigrationCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,77:1\n2792#2,3:78\n1276#3,2:81\n*S KotlinDebug\n*F\n+ 1 CustomEnumEntriesMigrationCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CustomEnumEntriesMigrationCallChecker\n*L\n35#1:78,3\n65#1:81,2\n*E\n"})
public final class CustomEnumEntriesMigrationCallChecker
implements CallChecker {
    @NotNull
    public static final CustomEnumEntriesMigrationCallChecker INSTANCE = new CustomEnumEntriesMigrationCallChecker();

    private CustomEnumEntriesMigrationCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        Object descriptor = obj;
        if (!(descriptor instanceof PropertyDescriptor)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((PropertyDescriptor)descriptor).getName(), (Object)StandardNames.ENUM_ENTRIES)) {
            return;
        }
        if (this.isExtensionWithEnumClassQualifier(resolvedCall2) || this.isCallViaCompanionOnEnumClassQualifier(resolvedCall2, (PropertyDescriptor)descriptor)) {
            context.getTrace().report(Errors.DEPRECATED_ACCESS_TO_ENUM_ENTRY_COMPANION_PROPERTY.on(reportOn));
        } else if (this.isCallToExternalEntriesInsideEnum((PropertyDescriptor)descriptor, reportOn)) {
            boolean bl;
            block11: {
                Iterable $this$none$iv = context.getTrace().getBindingContext().getDiagnostics().forElement(reportOn);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFactory(), Errors.DEPRECATED_ACCESS_TO_ENTRY_PROPERTY_FROM_ENUM)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                context.getTrace().report(Errors.DEPRECATED_ACCESS_TO_ENTRY_PROPERTY_FROM_ENUM.on(reportOn));
            }
        } else if (this.isReferenceToMemberEntriesWithoutExpectedFunctionalType((PropertyDescriptor)descriptor, reportOn, context)) {
            context.getTrace().report(Errors.DEPRECATED_ACCESS_TO_ENUM_ENTRY_PROPERTY_AS_REFERENCE.on(reportOn));
        }
    }

    private final boolean isExtensionWithEnumClassQualifier(ResolvedCall<?> $this$isExtensionWithEnumClassQualifier) {
        ReceiverValue receiverValue = $this$isExtensionWithEnumClassQualifier.getExtensionReceiver();
        if (receiverValue == null) {
            return false;
        }
        ReceiverValue receiver = receiverValue;
        return receiver instanceof ClassValueReceiver && DescriptorUtils.isEnumClass(((ClassValueReceiver)receiver).getClassQualifier().getDescriptor());
    }

    private final boolean isCallViaCompanionOnEnumClassQualifier(ResolvedCall<?> $this$isCallViaCompanionOnEnumClassQualifier, PropertyDescriptor descriptor) {
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!DescriptorUtilsKt.isCompanionObject(containingDeclaration)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = containingDeclaration.getContainingDeclaration();
        if (declarationDescriptor2 == null) {
            return false;
        }
        DeclarationDescriptor grandParent = declarationDescriptor2;
        if (!(grandParent instanceof ClassDescriptor) || !DescriptorUtils.isEnumClass(grandParent)) {
            return false;
        }
        return EnumEntryVsCompanionPriorityCallCheckerKt.isQualifierFor($this$isCallViaCompanionOnEnumClassQualifier.getDispatchReceiver(), (ClassDescriptor)grandParent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallToExternalEntriesInsideEnum(PropertyDescriptor $this$isCallToExternalEntriesInsideEnum, PsiElement contextExpression) {
        boolean bl;
        PsiElement parent2 = contextExpression.getParent();
        if (DescriptorUtils.isEnumClass($this$isCallToExternalEntriesInsideEnum.getContainingDeclaration())) return false;
        if (parent2 instanceof KtDotQualifiedExpression) {
            if (((KtDotQualifiedExpression)parent2).getReceiverExpression() != contextExpression) return false;
        }
        Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)contextExpression);
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            PsiElement it = (PsiElement)element$iv;
            boolean bl2 = false;
            if (it instanceof KtClass && ((KtClass)it).isEnum()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isReferenceToMemberEntriesWithoutExpectedFunctionalType(PropertyDescriptor $this$isReferenceToMemberEntriesWithoutExpectedFunctionalType, PsiElement expression2, CallCheckerContext context) {
        KotlinType kotlinType = context.getResolutionContext().expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        KotlinType expectedType = kotlinType;
        return expression2.getParent() instanceof KtCallableReferenceExpression && DescriptorUtils.isEnumClass($this$isReferenceToMemberEntriesWithoutExpectedFunctionalType.getContainingDeclaration()) && (TypeUtils.noExpectedType(expectedType) || !FunctionTypesKt.isFunctionType(expectedType));
    }
}

