/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.services;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.caches.UtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.services.LLFirJavaAnnotationProviderKt;
import org.jetbrains.kotlin.fir.java.FirJavaAnnotationProvider;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaPackage;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/services/LLFirJavaAnnotationProvider;", "Lorg/jetbrains/kotlin/fir/java/FirJavaAnnotationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "javaElementSourceFactory", "Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementSourceFactory;", "getJavaElementSourceFactory", "()Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementSourceFactory;", "javaElementSourceFactory$delegate", "Lkotlin/Lazy;", "packageAnnotationCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaAnnotation;", "getPackageAnnotations", "owner", "Lorg/jetbrains/kotlin/load/java/structure/JavaPackage;", "computePackageAnnotations", "psi", "Lcom/intellij/psi/PsiPackage;", "low-level-api-fir"})
public final class LLFirJavaAnnotationProvider
implements FirJavaAnnotationProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final Lazy javaElementSourceFactory$delegate;
    @NotNull
    private final Cache<FqName, List<JavaAnnotation>> packageAnnotationCache;

    public LLFirJavaAnnotationProvider(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.javaElementSourceFactory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> LLFirJavaAnnotationProvider.javaElementSourceFactory_delegate$lambda$0(this));
        Cache cache2 = Caffeine.newBuilder().maximumSize(1024L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.packageAnnotationCache = cache2;
    }

    private final JavaElementSourceFactory getJavaElementSourceFactory() {
        Lazy lazy = this.javaElementSourceFactory$delegate;
        return (JavaElementSourceFactory)lazy.getValue();
    }

    @NotNull
    public List<JavaAnnotation> getPackageAnnotations(@NotNull JavaPackage owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (!(owner instanceof JavaPackageImpl)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return UtilsKt.getOrPut(this.packageAnnotationCache, ((JavaPackageImpl)owner).getFqName(), arg_0 -> LLFirJavaAnnotationProvider.getPackageAnnotations$lambda$0(this, owner, arg_0));
    }

    private final List<JavaAnnotation> computePackageAnnotations(PsiPackage psi) {
        List list2;
        PsiDirectory[] psiDirectoryArray = psi.getDirectories(this.scope);
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"getDirectories(...)");
        PsiDirectory[] directories = psiDirectoryArray;
        if (directories.length == 0) {
            return CollectionsKt.emptyList();
        }
        List $this$computePackageAnnotations_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (PsiDirectory directory : directories) {
            PsiJavaFile packageStatement;
            PsiAnnotation[] psiAnnotationArray;
            PsiFile file;
            PsiJavaFile psiJavaFile;
            PsiFile psiFile = directory.findFile("package-info.java");
            if (psiFile == null) {
                psiFile = directory.findFile("package-info.class");
            }
            if ((psiJavaFile = (file = psiFile) instanceof PsiJavaFile ? (PsiJavaFile)file : null) == null || (psiJavaFile = psiJavaFile.getPackageStatement()) == null || (psiAnnotationArray = LLFirJavaAnnotationProviderKt.access$getPatchedAnnotationList((PsiPackageStatement)(packageStatement = psiJavaFile))) == null || (psiAnnotationArray = psiAnnotationArray.getAnnotations()) == null) continue;
            for (PsiAnnotation psiAnnotation : psiAnnotationArray) {
                JavaElementSourceFactory javaElementSourceFactory = this.getJavaElementSourceFactory();
                Intrinsics.checkNotNull((Object)psiAnnotation);
                JavaElementPsiSource psiSource = javaElementSourceFactory.createPsiSource((PsiElement)psiAnnotation);
                JavaAnnotationImpl javaAnnotation = new JavaAnnotationImpl(psiSource);
                $this$computePackageAnnotations_u24lambda_u240.add(javaAnnotation);
            }
        }
        return CollectionsKt.build((List)list2);
    }

    private static final JavaElementSourceFactory javaElementSourceFactory_delegate$lambda$0(LLFirJavaAnnotationProvider this$0) {
        return JavaElementSourceFactory.Companion.getInstance(this$0.project);
    }

    private static final List getPackageAnnotations$lambda$0(LLFirJavaAnnotationProvider this$0, JavaPackage $owner, FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = ((JavaPackageImpl)$owner).getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        return this$0.computePackageAnnotations((PsiPackage)psiElement);
    }
}

