/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ9\u0010\u000e\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)V", "checkTypeAliasExpansionCapturesOuterTypeParameters", "fullyExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expandedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnyTypeAliasChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnyTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n36#2:106\n1#3:107\n*S KotlinDebug\n*F\n+ 1 FirAnyTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnyTypeAliasChecker\n*L\n78#1:106\n*E\n"})
public final class FirAnyTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirAnyTypeAliasChecker INSTANCE = new FirAnyTypeAliasChecker();

    private FirAnyTypeAliasChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!FirHelpersKt.isTopLevel(context2)) {
            FirHelpersKt.requireFeatureSupport$default(context2, reporter, declaration, declaration.isLocal() ? LanguageFeature.LocalTypeAliases : LanguageFeature.NestedTypeAliases, null, 8, null);
        }
        FirTypeRef expandedTypeRef = declaration.getExpandedTypeRef();
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(expandedTypeRef));
        this.checkTypeAliasExpansionCapturesOuterTypeParameters(context2, reporter, declaration, fullyExpandedType2, expandedTypeRef);
        if (!ConeTypeUtilsKt.hasError(fullyExpandedType2)) {
            FirRegularClassSymbol expandedClassSymbol;
            FirRegularClassSymbol firRegularClassSymbol = expandedClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, fullyExpandedType2);
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS && FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport(context2.getSession()).getRequiredAnnotations().contains(expandedClassSymbol.getClassId())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expandedTypeRef.getSource()), FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_COMPILER_REQUIRED_ANNOTATION(), (Object)expandedClassSymbol, null, (int)16, null);
            }
            if ((expandedClassSymbol == null || fullyExpandedType2 instanceof ConeDynamicType) && ToSymbolUtilsKt.toTypeAliasSymbol((SessionHolder)context2, FirTypeUtilsKt.getConeType(expandedTypeRef)) == null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expandedTypeRef.getSource()), FirErrors.INSTANCE.getTYPEALIAS_SHOULD_EXPAND_TO_CLASS(), (Object)fullyExpandedType2, null, (int)16, null);
            }
        }
        FirUnderscoreHelpersKt.checkTypeRefForUnderscore(context2, reporter, expandedTypeRef);
        boolean allowNullableNothing = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.NullableNothingInReifiedPosition);
        if (FirHelpersKt.isMalformedExpandedType(context2, fullyExpandedType2, allowNullableNothing)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getExpandedTypeRef().getSource()), FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_ARRAY_OF_NOTHINGS(), (Object)fullyExpandedType2, null, (int)16, null);
        }
    }

    private final void checkTypeAliasExpansionCapturesOuterTypeParameters(CheckerContext context2, DiagnosticReporter reporter, FirTypeAlias $this$checkTypeAliasExpansionCapturesOuterTypeParameters, ConeKotlinType fullyExpandedType2, FirTypeRef expandedTypeRef) {
        block5: {
            block4: {
                if (FirHelpersKt.isTopLevel(context2)) break block4;
                FirMemberDeclaration $this$isInner$iv = $this$checkTypeAliasExpansionCapturesOuterTypeParameters;
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) break block5;
            }
            return;
        }
        Set unsubstitutedOuterTypeParameters = new LinkedHashSet();
        FirAnyTypeAliasChecker.checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively(context2, $this$checkTypeAliasExpansionCapturesOuterTypeParameters, unsubstitutedOuterTypeParameters, fullyExpandedType2);
        if (!((Collection)unsubstitutedOuterTypeParameters).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expandedTypeRef.getSource()), FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_CAPTURES_OUTER_TYPE_PARAMETERS(), (Object)unsubstitutedOuterTypeParameters, null, (int)16, null);
        }
    }

    private static final void checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively(CheckerContext $context, FirTypeAlias $this_checkTypeAliasExpansionCapturesOuterTypeParameters, Set<FirTypeParameterSymbol> unsubstitutedOuterTypeParameters, ConeKotlinType coneType) {
        for (ConeTypeProjection typeArgument : coneType.getTypeArguments()) {
            ConeKotlinType coneKotlinType;
            ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType(typeArgument);
            if (coneKotlinType2 == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)$context, coneKotlinType2)) == null) continue;
            ConeKotlinType it = coneKotlinType;
            boolean bl = false;
            FirAnyTypeAliasChecker.checkTypeAliasExpansionCapturesOuterTypeParameters$checkRecursively($context, $this_checkTypeAliasExpansionCapturesOuterTypeParameters, unsubstitutedOuterTypeParameters, it);
        }
        FirTypeParameterSymbol firTypeParameterSymbol = ToSymbolUtilsKt.toTypeParameterSymbol($context, coneType);
        if (firTypeParameterSymbol == null) {
            return;
        }
        FirTypeParameterSymbol typeParameterSymbol = firTypeParameterSymbol;
        if (!Intrinsics.areEqual((Object)$this_checkTypeAliasExpansionCapturesOuterTypeParameters.getSymbol(), typeParameterSymbol.getContainingDeclarationSymbol())) {
            unsubstitutedOuterTypeParameters.add(typeParameterSymbol);
        }
    }
}

