/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.restrictedAnalysis.KotlinRestrictedAnalysisService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J!\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinRestrictedAnalysisService;", "Lorg/jetbrains/kotlin/analysis/api/platform/restrictedAnalysis/KotlinRestrictedAnalysisService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isAnalysisRestricted", "", "()Z", "isRestrictedAnalysisAllowed", "rejectRestrictedAnalysis", "", "runWithRestrictedDataAccess", "R", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.kotlin.base.analysis.platform"})
public final class IdeKotlinRestrictedAnalysisService
implements KotlinRestrictedAnalysisService {
    @NotNull
    private final Project project;
    private final boolean isRestrictedAnalysisAllowed;

    public IdeKotlinRestrictedAnalysisService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isRestrictedAnalysisAllowed = Registry.Companion.is("kotlin.analysis.allowRestrictedAnalysis", true);
    }

    @Override
    public boolean isAnalysisRestricted() {
        return DumbService.Companion.isDumb(this.project);
    }

    @Override
    public boolean isRestrictedAnalysisAllowed() {
        return this.isRestrictedAnalysisAllowed;
    }

    @Override
    @NotNull
    public Void rejectRestrictedAnalysis() {
        IndexNotReadyException indexNotReadyException = IndexNotReadyException.create();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)indexNotReadyException), (String)"create(...)");
        throw (Throwable)indexNotReadyException;
    }

    @Override
    public <R> R runWithRestrictedDataAccess(@NotNull Function0<? extends R> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        return (R)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RELIABLE_DATA_ONLY, () -> IdeKotlinRestrictedAnalysisService.runWithRestrictedDataAccess$lambda$0(action2));
    }

    private static final Object runWithRestrictedDataAccess$lambda$0(Function0 $tmp0) {
        return $tmp0.invoke();
    }
}

