/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.PrefixedStringTemplateUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000e*\u0004\u0018\u00010\u0016H\u0002J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J(\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000eH\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J&\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010&\u001a\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$H\u0002J\u001e\u0010)\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0014H\u0002J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0014H&\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/ConvertToConcatenatedStringIntentionBase;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "<init>", "()V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isElementApplicable", "", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "safeDeparenthesizeOperands", "Lorg/jetbrains/kotlin/psi/KtExpression;", "needsExplicitToStringConversion", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "toOperandExpressions", "", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "oldPrefixLength", "", "isSingleQuoted", "createStringTemplate", "content", "prefixLength", "isMultiQuoted", "mergeStringGroups", "unmergedOperandsQueue", "Lkotlin/collections/ArrayDeque;", "mergeNextSequentialStrings", "firstString", "findNextStringGroup", "", "convertFirstToString", "needsParentheses", "expression", "isExpressionOfStringType", "intellij.kotlin.codeInsight.shared"})
@SourceDebugExtension(value={"SMAP\nConvertToConcatenatedStringIntentionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToConcatenatedStringIntentionBase.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/ConvertToConcatenatedStringIntentionBase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n12970#2,2:189\n4244#2:192\n4344#2,2:193\n4244#2:200\n4344#2,2:201\n1#3:191\n1460#4,5:195\n1374#4:203\n1460#4,5:204\n967#4,7:209\n*S KotlinDebug\n*F\n+ 1 ConvertToConcatenatedStringIntentionBase.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/ConvertToConcatenatedStringIntentionBase\n*L\n29#1:189,2\n37#1:192\n37#1:193,2\n86#1:200\n86#1:201,2\n41#1:195,5\n87#1:203\n87#1:204,5\n155#1:209,7\n*E\n"})
public abstract class ConvertToConcatenatedStringIntentionBase
extends PsiUpdateModCommandAction<KtStringTemplateExpression> {
    public ConvertToConcatenatedStringIntentionBase() {
        super(KtStringTemplateExpression.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.LOW);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.template.to.concatenated.string", (Object[])new Object[0]);
    }

    protected boolean isElementApplicable(@NotNull KtStringTemplateExpression element, @NotNull ActionContext context2) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!Intrinsics.areEqual((Object)element.getLastChild().getNode().getElementType(), (Object)KtTokens.CLOSING_QUOTE)) {
                return false;
            }
            KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
            Object[] $this$any$iv = ktStringTemplateEntryArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv;
                boolean bl2 = false;
                if (!(it instanceof KtStringTemplateEntryWithExpression)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected void invoke(@NotNull ActionContext context2, @NotNull KtStringTemplateExpression element, @NotNull ModPsiUpdater updater2) {
        void $this$flatMapTo$iv;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        if (element.getText() == null) {
            boolean $i$a$-checkNotNull-ConvertToConcatenatedStringIntentionBase$invoke$22 = false;
            String $i$a$-checkNotNull-ConvertToConcatenatedStringIntentionBase$invoke$22 = "Failed to get template expression's text";
            throw new IllegalStateException($i$a$-checkNotNull-ConvertToConcatenatedStringIntentionBase$invoke$22.toString());
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        int oldPrefixLength = PrefixedStringTemplateUtilsKt.getEntryPrefixLength(element);
        KtStringTemplateEntry[] ktStringTemplateEntryArray = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$filterNot$iv = ktStringTemplateEntryArray;
        boolean $i$f$filterNot = false;
        Object[] objectArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (void element$iv$iv : $this$filterNotTo$iv$iv) {
            KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv$iv;
            boolean bl = false;
            if (it instanceof KtStringTemplateEntryWithExpression && ((KtStringTemplateEntryWithExpression)it).getExpression() == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        boolean convertFirstEntryExplicitly = this.needsExplicitToStringConversion((KtStringTemplateEntry)CollectionsKt.firstOrNull((List)entries));
        ArrayDeque unmergedOperandsQueue = new ArrayDeque();
        $this$filterNotTo$iv$iv = entries;
        Collection destination$iv = (Collection)unmergedOperandsQueue;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            KtStringTemplateEntry topLevelEntry = (KtStringTemplateEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)topLevelEntry);
            Iterable list$iv = this.toOperandExpressions(topLevelEntry, psiFactory, oldPrefixLength, KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)element));
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        if (convertFirstEntryExplicitly) {
            this.convertFirstToString((ArrayDeque<KtExpression>)unmergedOperandsQueue, psiFactory);
        }
        List<KtExpression> mergedOperands = this.mergeStringGroups((ArrayDeque<KtExpression>)unmergedOperandsQueue, psiFactory);
        KtExpression replacement = this.safeDeparenthesizeOperands(psiFactory.createExpression(CollectionsKt.joinToString$default((Iterable)mergedOperands, (CharSequence)" + ", null, null, (int)0, null, ConvertToConcatenatedStringIntentionBase::invoke$lambda$3, (int)30, null)));
        element.replace((PsiElement)replacement);
    }

    private final KtExpression safeDeparenthesizeOperands(KtExpression $this$safeDeparenthesizeOperands) {
        if ($this$safeDeparenthesizeOperands instanceof KtBinaryExpression) {
            KtExpression ktExpression = ((KtBinaryExpression)$this$safeDeparenthesizeOperands).getLeft();
            Intrinsics.checkNotNull((Object)ktExpression);
            KtExpression deparenthesizedLeft = this.safeDeparenthesizeOperands(ktExpression);
            KtExpression ktExpression2 = ((KtBinaryExpression)$this$safeDeparenthesizeOperands).getRight();
            Intrinsics.checkNotNull((Object)ktExpression2);
            KtExpression deparenthesizedRight = this.safeDeparenthesizeOperands(ktExpression2);
            Project project = ((KtBinaryExpression)$this$safeDeparenthesizeOperands).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)deparenthesizedLeft.getText(), (String)"getText(...)");
            Intrinsics.checkNotNullExpressionValue((Object)deparenthesizedRight.getText(), (String)"getText(...)");
            return CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0+$1", (Object[])objectArray, (boolean)false, (int)4, null);
        }
        if ($this$safeDeparenthesizeOperands instanceof KtParenthesizedExpression && KtPsiUtil.areParenthesesUseless((KtParenthesizedExpression)((KtParenthesizedExpression)$this$safeDeparenthesizeOperands))) {
            KtExpression ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)$this$safeDeparenthesizeOperands, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(...)");
            return ktExpression;
        }
        return $this$safeDeparenthesizeOperands;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needsExplicitToStringConversion(KtStringTemplateEntry $this$needsExplicitToStringConversion) {
        if (!($this$needsExplicitToStringConversion instanceof KtStringTemplateEntryWithExpression)) {
            return false;
        }
        KtExpression ktExpression = ((KtStringTemplateEntryWithExpression)$this$needsExplicitToStringConversion).getExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression = ktExpression;
        if (!this.isExpressionOfStringType(expression)) return true;
        if (!(expression instanceof KtStringTemplateExpression)) return false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)expression).getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        if (!this.needsExplicitToStringConversion((KtStringTemplateEntry)ArraysKt.firstOrNull((Object[])ktStringTemplateEntryArray))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> toOperandExpressions(KtStringTemplateEntry $this$toOperandExpressions, KtPsiFactory psiFactory, int oldPrefixLength, boolean isSingleQuoted) {
        List list2;
        if ($this$toOperandExpressions instanceof KtStringTemplateEntryWithExpression) {
            KtExpression ktExpression = ((KtStringTemplateEntryWithExpression)$this$toOperandExpressions).getExpression();
            if (ktExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtExpression expression = ktExpression;
            if (expression instanceof KtStringTemplateExpression) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)expression).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
                Object[] objectArray = ktStringTemplateEntryArray;
                boolean $i$f$filterNot = false;
                void var8_9 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (void element$iv$iv : $this$filterNotTo$iv$iv) {
                    KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv$iv;
                    boolean bl = false;
                    if (it instanceof KtStringTemplateEntryWithExpression && ((KtStringTemplateEntryWithExpression)it).getExpression() == null) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$filterNotTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    KtStringTemplateEntry nestedEntry = (KtStringTemplateEntry)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)nestedEntry);
                    Iterable list$iv$iv = this.toOperandExpressions(nestedEntry, psiFactory, PrefixedStringTemplateUtilsKt.getEntryPrefixLength((KtStringTemplateExpression)expression), KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)((KtStringTemplateExpression)expression)));
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                Object text = this.needsParentheses(expression) ? "(" + expression.getText() + ")" : expression.getText();
                Intrinsics.checkNotNull((Object)text);
                list2 = CollectionsKt.listOf((Object)psiFactory.createExpression((String)text));
            }
        } else {
            String string = $this$toOperandExpressions.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            list2 = CollectionsKt.listOf((Object)this.createStringTemplate(psiFactory, string, oldPrefixLength, !isSingleQuoted));
        }
        return list2;
    }

    private final KtStringTemplateExpression createStringTemplate(KtPsiFactory psiFactory, String content, int prefixLength, boolean isMultiQuoted) {
        return prefixLength > 1 ? psiFactory.createMultiDollarStringTemplate(content, prefixLength, isMultiQuoted) : (isMultiQuoted ? psiFactory.createRawStringTemplate(content) : psiFactory.createStringTemplate(content));
    }

    private final List<KtExpression> mergeStringGroups(ArrayDeque<KtExpression> unmergedOperandsQueue, KtPsiFactory psiFactory) {
        List mergedOperands = new ArrayList();
        while (!((Collection)unmergedOperandsQueue).isEmpty()) {
            boolean bl;
            KtExpression nextOperand = (KtExpression)unmergedOperandsQueue.removeFirst();
            if (nextOperand instanceof KtStringTemplateExpression) {
                KtStringTemplateExpression mergedStringGroup = this.mergeNextSequentialStrings((KtStringTemplateExpression)nextOperand, unmergedOperandsQueue, psiFactory);
                bl = mergedOperands.add(mergedStringGroup);
                continue;
            }
            bl = mergedOperands.add(nextOperand);
        }
        return mergedOperands;
    }

    private final KtStringTemplateExpression mergeNextSequentialStrings(KtStringTemplateExpression firstString, ArrayDeque<KtExpression> unmergedOperandsQueue, KtPsiFactory psiFactory) {
        List<KtStringTemplateExpression> group = this.findNextStringGroup(firstString, unmergedOperandsQueue);
        String concatenatedText = CollectionsKt.joinToString$default((Iterable)group, (CharSequence)"", null, null, (int)0, null, ConvertToConcatenatedStringIntentionBase::mergeNextSequentialStrings$lambda$0, (int)30, null);
        KtStringTemplateExpression tempStringForPrefixEstimation = this.createStringTemplate(psiFactory, concatenatedText, 1, !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)firstString));
        int prefixLength = PrefixedStringTemplateUtilsKt.findPrefixLengthForPlainTextConversion(tempStringForPrefixEstimation);
        KtStringTemplateExpression merged = this.createStringTemplate(psiFactory, concatenatedText, prefixLength, !KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)firstString));
        return merged;
    }

    private final List<KtStringTemplateExpression> findNextStringGroup(KtStringTemplateExpression firstString, ArrayDeque<KtExpression> unmergedOperandsQueue) {
        Object[] objectArray = new KtStringTemplateExpression[]{firstString};
        List group = CollectionsKt.mutableListOf((Object[])objectArray);
        Iterable $this$takeWhile$iv = (Iterable)unmergedOperandsQueue;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            KtExpression next2 = (KtExpression)item$iv;
            boolean bl = false;
            if (!(next2 instanceof KtStringTemplateExpression && KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)((KtStringTemplateExpression)next2)) == KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)firstString))) break;
            list$iv.add(item$iv);
        }
        List nextAcceptableStrings = list$iv;
        group.addAll(nextAcceptableStrings);
        int n = nextAcceptableStrings.size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            unmergedOperandsQueue.removeFirst();
        }
        return group;
    }

    private final void convertFirstToString(ArrayDeque<KtExpression> unmergedOperandsQueue, KtPsiFactory psiFactory) {
        if (unmergedOperandsQueue.isEmpty()) {
            return;
        }
        KtExpression first2 = (KtExpression)unmergedOperandsQueue.removeFirst();
        unmergedOperandsQueue.addFirst((Object)psiFactory.createExpression(first2.getText() + ".toString()"));
    }

    private final boolean needsParentheses(KtExpression expression) {
        KtExpression ktExpression = expression;
        return ktExpression instanceof KtPostfixExpression ? false : (ktExpression instanceof KtAnnotatedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtOperationExpression ? true : (ktExpression instanceof KtIfExpression ? !(((KtIfExpression)expression).getElse() instanceof KtBlockExpression) : false));
    }

    public abstract boolean isExpressionOfStringType(@NotNull KtExpression var1);

    private static final CharSequence invoke$lambda$3(KtExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final CharSequence mergeNextSequentialStrings$lambda$0(KtStringTemplateExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = KtPsiUtilKt.getContentRange((KtStringTemplateExpression)it).substring(it.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

