/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointTypeKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitorKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.Lines;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 _2\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001_B\u0019\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010#J\u001f\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010+J\u001f\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010/J\u001f\u00100\u001a\u00020\u00022\u0006\u00101\u001a\u0002022\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00103J\u001f\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00107J\u001f\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010;J\u001f\u0010<\u001a\u00020\u00022\u0006\u0010=\u001a\u00020>2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010?J\u001f\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010CJ\u001f\u0010D\u001a\u00020\u00022\u0006\u0010E\u001a\u00020F2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010GJ\u001f\u0010H\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020I2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010JJ\u001f\u0010K\u001a\u00020\u00022\u0006\u0010L\u001a\u00020M2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010NJ\u001f\u0010O\u001a\u00020\u00022\u0006\u0010P\u001a\u00020Q2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010RJ\u001f\u0010S\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020T2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010UJ\u001f\u0010V\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020W2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010XJ\u000e\u0010Y\u001a\u00020Z*\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010[\u001a\u00020\\*\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010]\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010^\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "", "document", "Lcom/intellij/openapi/editor/Document;", "mainLine", "", "<init>", "(Lcom/intellij/openapi/editor/Document;I)V", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "data", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitChildren", "children", "", "Lcom/intellij/psi/PsiElement;", "(Ljava/util/List;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitCatchSection", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "(Lorg/jetbrains/kotlin/psi/KtCatchClause;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitPackageDirective", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "(Lorg/jetbrains/kotlin/psi/KtPackageDirective;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitPropertyDelegate", "delegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "(Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitWhenEntry", "ktWhenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "(Lorg/jetbrains/kotlin/psi/KtWhenEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitDestructuringDeclaration", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "isSameLine", "", "getLines", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/Lines;", "acceptIfMultiLineParent", "parent", "Companion", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nLineBreakpointExpressionVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineBreakpointExpressionVisitor.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class LineBreakpointExpressionVisitor
extends KtVisitor<ApplicabilityResult, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    private final int mainLine;

    private LineBreakpointExpressionVisitor(Document document, int mainLine) {
        this.document = document;
        this.mainLine = mainLine;
    }

    @NotNull
    public ApplicabilityResult visitKtElement(@NotNull KtElement element, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement[] psiElementArray = element.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        return this.visitChildren(ArraysKt.asList((Object[])psiElementArray), data);
    }

    private final ApplicabilityResult visitChildren(List<? extends PsiElement> children, Unit data) {
        if (children.isEmpty() || !this.isSameLine((PsiElement)CollectionsKt.first(children))) {
            return ApplicabilityResult.UNKNOWN;
        }
        boolean isApplicable2 = false;
        for (PsiElement psiElement : children) {
            ApplicabilityResult result2;
            KtElement ktElement;
            KtElement ktElement2 = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (ktElement2 == null || (ApplicabilityResult)(ktElement = ktElement2).accept((KtVisitor)this, (Object)data) == null) continue;
            if (result2.getShouldStop()) {
                return result2;
            }
            isApplicable2 |= result2.isApplicable();
        }
        return ApplicabilityResult.Companion.maybe(isApplicable2);
    }

    @NotNull
    public ApplicabilityResult visitExpression(@NotNull KtExpression expression, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isSameLine((PsiElement)expression)) {
            ApplicabilityResult superResult = (ApplicabilityResult)super.visitExpression(expression, (Object)data);
            if (superResult.getShouldStop()) {
                Intrinsics.checkNotNull((Object)superResult);
                return superResult;
            }
            return ApplicabilityResult.MAYBE_YES;
        }
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitClass(@NotNull KtClass klass, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        ApplicabilityResult applicabilityResult = LineBreakpointExpressionVisitorKt.access$handle(this.visitChildren(klass.getPrimaryConstructorParameters(), data));
        if (applicabilityResult != null) {
            ApplicabilityResult it = applicabilityResult;
            boolean bl = false;
            return it;
        }
        Object object = klass.getBody();
        if (object == null || (object = (ApplicabilityResult)object.accept((KtVisitor)this, (Object)data)) == null) {
            object = ApplicabilityResult.UNKNOWN;
        }
        return object;
    }

    @NotNull
    public ApplicabilityResult visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Object object = declaration.getBody();
        if (object == null || (object = (ApplicabilityResult)object.accept((KtVisitor)this, (Object)data)) == null) {
            object = ApplicabilityResult.UNKNOWN;
        }
        return object;
    }

    @NotNull
    public ApplicabilityResult visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, @Nullable Unit data) {
        ApplicabilityResult applicabilityResult;
        ApplicabilityResult applicabilityResult2;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        KtBlockExpression ktBlockExpression = constructor.getBodyExpression();
        return ktBlockExpression != null && (applicabilityResult2 = (ApplicabilityResult)ktBlockExpression.accept((KtVisitor)this, (Object)data)) != null && (applicabilityResult = this.acceptIfMultiLineParent(applicabilityResult2, (KtExpression)constructor)) != null ? applicabilityResult : ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitParameter(@NotNull KtParameter parameter, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        KtExpression defaultValue = parameter.getDefaultValue();
        if (this.isSameLine((PsiElement)defaultValue)) {
            return ApplicabilityResult.DEFINITELY_YES;
        }
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitCatchSection(@NotNull KtCatchClause catchClause, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
        return ApplicabilityResult.MAYBE_YES;
    }

    @NotNull
    public ApplicabilityResult visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitPackageDirective(@NotNull KtPackageDirective directive, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitImportDirective(@NotNull KtImportDirective importDirective, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitProperty(@NotNull KtProperty property, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (property.hasModifier(KtTokens.CONST_KEYWORD)) {
            return ApplicabilityResult.UNKNOWN;
        }
        Object object = super.visitProperty(property, (Object)data);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visitProperty(...)");
        return (ApplicabilityResult)object;
    }

    @NotNull
    public ApplicabilityResult visitNamedFunction(@NotNull KtNamedFunction function, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.isSameLine((PsiElement)function) && KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)function))) {
            return ApplicabilityResult.MAYBE_YES;
        }
        ApplicabilityResult applicabilityResult = LineBreakpointExpressionVisitorKt.access$handle(this.visitChildren(function.getValueParameters(), data));
        if (applicabilityResult != null) {
            ApplicabilityResult it = applicabilityResult;
            boolean bl = false;
            return it;
        }
        Object object = function.getBodyExpression();
        if (object == null || (object = (ApplicabilityResult)object.accept((KtVisitor)this, (Object)data)) == null) {
            object = ApplicabilityResult.UNKNOWN;
        }
        return object;
    }

    @NotNull
    public ApplicabilityResult visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, @Nullable Unit data) {
        ApplicabilityResult applicabilityResult;
        ApplicabilityResult applicabilityResult2;
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        KtExpression ktExpression = accessor.getBodyExpression();
        return ktExpression != null && (applicabilityResult2 = (ApplicabilityResult)ktExpression.accept((KtVisitor)this, (Object)data)) != null && (applicabilityResult = this.acceptIfMultiLineParent(applicabilityResult2, (KtExpression)accessor)) != null ? applicabilityResult : ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitPropertyDelegate(@NotNull KtPropertyDelegate delegate, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return ApplicabilityResult.Companion.maybe(this.isSameLine((PsiElement)delegate));
    }

    @NotNull
    public ApplicabilityResult visitLambdaExpression(@NotNull KtLambdaExpression expression, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isSameLine((PsiElement)expression)) {
            PsiElement[] psiElementArray = expression.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object object = ArraysKt.singleOrNull((Object[])psiElementArray);
            KtFunctionLiteral ktFunctionLiteral = object instanceof KtFunctionLiteral ? (KtFunctionLiteral)object : null;
            if (ktFunctionLiteral == null) {
                return ApplicabilityResult.DEFINITELY_YES;
            }
            KtFunctionLiteral lambda2 = ktFunctionLiteral;
            if (KotlinLineBreakpointTypeKt.isSuitableLambdaBreakpointTarget((KtFunction)lambda2, this.mainLine)) {
                return ApplicabilityResult.DEFINITELY_YES;
            }
        }
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitWhenEntry(@NotNull KtWhenEntry ktWhenEntry, @Nullable Unit data) {
        ApplicabilityResult applicabilityResult;
        ApplicabilityResult applicabilityResult2;
        Intrinsics.checkNotNullParameter((Object)ktWhenEntry, (String)"ktWhenEntry");
        KtExpression ktExpression = ktWhenEntry.getExpression();
        if (ktExpression != null && (applicabilityResult2 = (ApplicabilityResult)ktExpression.accept((KtVisitor)this, (Object)data)) != null && (applicabilityResult = LineBreakpointExpressionVisitorKt.access$handle(applicabilityResult2)) != null) {
            ApplicabilityResult it = applicabilityResult;
            boolean bl = false;
            return it;
        }
        KtWhenCondition[] ktWhenConditionArray = ktWhenEntry.getConditions();
        Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
        return ApplicabilityResult.Companion.maybe(!(((Object[])ktWhenConditionArray).length == 0) || ktWhenEntry.isElse());
    }

    @NotNull
    public ApplicabilityResult visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)multiDeclaration, (String)"multiDeclaration");
        return ApplicabilityResult.Companion.maybe(this.isSameLine((PsiElement)multiDeclaration));
    }

    @NotNull
    public ApplicabilityResult visitBlockExpression(@NotNull KtBlockExpression expression, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List list2 = expression.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        return this.visitChildren(list2, data);
    }

    @NotNull
    public ApplicabilityResult visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression ktExpression = expression.getExpression();
        if (ktExpression == null) {
            return ApplicabilityResult.UNKNOWN;
        }
        KtExpression parenthesized = ktExpression;
        Lines lines = this.getLines((PsiElement)parenthesized);
        if (lines.getStart() > this.mainLine) {
            return ApplicabilityResult.UNKNOWN;
        }
        if (lines.isMultiLine()) {
            ApplicabilityResult applicabilityResult = (ApplicabilityResult)parenthesized.accept((KtVisitor)this, (Object)data);
            if (applicabilityResult == null) {
                applicabilityResult = ApplicabilityResult.UNKNOWN;
            }
            return applicabilityResult;
        }
        return ApplicabilityResult.UNKNOWN;
    }

    private final boolean isSameLine(PsiElement $this$isSameLine) {
        Lines lines = this.getLines($this$isSameLine);
        return lines.getStart() == this.mainLine;
    }

    private final Lines getLines(PsiElement $this$getLines) {
        if ($this$getLines == null) {
            return Lines.Companion.getEMPTY();
        }
        int startOffset = Math.max(PsiUtilsKt.getStartOffset((PsiElement)$this$getLines), $this$getLines.getTextOffset());
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)$this$getLines);
        if (startOffset < 0 || endOffset < 0 || startOffset > endOffset) {
            return Lines.Companion.getEMPTY();
        }
        int maxOffset = this.document.getTextLength();
        if (startOffset > maxOffset || endOffset > maxOffset) {
            return Lines.Companion.getEMPTY();
        }
        int startLine = this.document.getLineNumber(startOffset);
        int endLine = this.document.getLineNumber(endOffset);
        return new Lines(startLine, endLine);
    }

    private final ApplicabilityResult acceptIfMultiLineParent(ApplicabilityResult $this$acceptIfMultiLineParent, KtExpression parent) {
        if ($this$acceptIfMultiLineParent.getShouldStop()) {
            return $this$acceptIfMultiLineParent;
        }
        if (this.getLines((PsiElement)parent).isSingleLine()) {
            return null;
        }
        return $this$acceptIfMultiLineParent;
    }

    @JvmStatic
    @Nullable
    public static final LineBreakpointExpressionVisitor of(@NotNull VirtualFile file, int line) {
        return Companion.of(file, line);
    }

    public /* synthetic */ LineBreakpointExpressionVisitor(Document document, int mainLine, DefaultConstructorMarker $constructor_marker) {
        this(document, mainLine);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor$Companion;", "", "<init>", "()V", "of", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "intellij.kotlin.jvm.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final LineBreakpointExpressionVisitor of(@NotNull VirtualFile file, int line) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return null;
            }
            Document document2 = document;
            return new LineBreakpointExpressionVisitor(document2, line, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

