/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.expectactual;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.expectActual.KotlinTypeInaccessibleException;
import org.jetbrains.kotlin.idea.quickfix.TypeAccessibilityChecker;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.CreateClassUtil;
import org.jetbrains.kotlin.idea.quickfix.expectactual.EscapeXMLKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u001a~\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u0002H\u00022\u0006\u0010\u000e\u001a\u00020\u000f2+\u0010\u0010\u001a'\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u0011\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\u0010\u0015\u001a\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u0017\u001a\"\u0010\u001e\u001a\u00020\u0017*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!2\u0006\u0010\u0019\u001a\u00020\u0017H\u0002\u001a\"\u0010\"\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a$\u0010&\u001a\u00020%*\u00020'2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0!2\b\b\u0002\u0010*\u001a\u00020+\u001a\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020%0-*\u00020\u00132\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030!\"\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"generateExpectOrActualInFile", "", "D", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetFile", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "element", "module", "Lcom/intellij/openapi/module/Module;", "generateIt", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/TypeAccessibilityChecker;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/openapi/module/Module;Lkotlin/jvm/functions/Function4;)V", "isCorrectAndHaveAccessibleModifiers", "", "declaration", "showErrorHint", "INACCESSIBLE_MODIFIERS", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "anyInaccessibleModifier", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifiers", "", "showInaccessibleDeclarationError", "Lcom/intellij/psi/PsiElement;", "message", "", "typesToString", "Lorg/jetbrains/kotlin/idea/quickfix/TypeAccessibilityChecker$Companion;", "types", "Lorg/jetbrains/kotlin/name/FqName;", "separator", "", "findAndApplyExistingClasses", "", "elements", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nExpectActualUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualUtils.kt\norg/jetbrains/kotlin/idea/quickfix/expectactual/ExpectActualUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtClassOrObject.kt\norg/jetbrains/kotlin/psi/KtClassOrObject\n*L\n1#1,165:1\n1#2:166\n1#2:188\n808#3,11:167\n1617#3,9:178\n1869#3:187\n1870#3:189\n1626#3:190\n774#3:191\n865#3,2:192\n68#4,6:194\n*S KotlinDebug\n*F\n+ 1 ExpectActualUtils.kt\norg/jetbrains/kotlin/idea/quickfix/expectactual/ExpectActualUtilsKt\n*L\n154#1:188\n152#1:167,11\n154#1:178,9\n154#1:187\n154#1:189\n154#1:190\n157#1:191\n157#1:192,2\n82#1:194,6\n*E\n"})
public final class ExpectActualUtilsKt {
    @NotNull
    private static final List<KtModifierKeywordToken> INACCESSIBLE_MODIFIERS;

    public static final <D extends KtNamedDeclaration> void generateExpectOrActualInFile(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile originalFile, @NotNull KtFile targetFile, @Nullable KtClassOrObject targetClass, @NotNull D element, @NotNull Module module, @NotNull Function4<? super KtPsiFactory, ? super Project, ? super TypeAccessibilityChecker, ? super D, ? extends D> generateIt) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(generateIt, (String)"generateIt");
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        KtClassOrObject ktClassOrObject = targetClass;
        SmartPsiElementPointer targetClassPointer = ktClassOrObject != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktClassOrObject)) : null;
        SmartPsiElementPointer targetFilePointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)targetFile));
        DumbService.Companion.getInstance(project).runWhenSmart(() -> ExpectActualUtilsKt.generateExpectOrActualInFile$lambda$0(generateIt, factory2, project, module, element, editor, targetFilePointer, originalFile, targetClassPointer));
    }

    public static final boolean isCorrectAndHaveAccessibleModifiers(@NotNull TypeAccessibilityChecker $this$isCorrectAndHaveAccessibleModifiers, @NotNull KtNamedDeclaration declaration, boolean showErrorHint) {
        Intrinsics.checkNotNullParameter((Object)$this$isCorrectAndHaveAccessibleModifiers, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (ExpectActualUtilsKt.anyInaccessibleModifier((KtModifierListOwner)declaration, (Collection<KtModifierKeywordToken>)INACCESSIBLE_MODIFIERS, showErrorHint)) {
            return false;
        }
        if (declaration instanceof KtFunction && ((KtFunction)declaration).hasBody()) {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
            boolean bl = ktClassOrObject != null ? KotlinRefactoringUtilKt.isInterfaceClass((PsiNamedElement)ktClassOrObject) : false;
            if (bl) {
                if (showErrorHint) {
                    ExpectActualUtilsKt.showInaccessibleDeclarationError$default((PsiElement)declaration, KotlinBundle.message((String)"the.function.declaration.shouldn.t.have.a.default.implementation", (Object[])new Object[0]), null, 4, null);
                }
                return false;
            }
        }
        if (!showErrorHint) {
            return $this$isCorrectAndHaveAccessibleModifiers.checkAccessibility(declaration);
        }
        Object[] objectArray = $this$isCorrectAndHaveAccessibleModifiers.incorrectTypes(declaration);
        if (objectArray.isEmpty()) {
            boolean bl = false;
            return true;
        }
        Object[] types = objectArray;
        PsiElement psiElement = (PsiElement)declaration;
        objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)$this$isCorrectAndHaveAccessibleModifiers.getTargetModule().getName(), (String)"getName(...)");
        objectArray[1] = ExpectActualUtilsKt.typesToString$default(TypeAccessibilityChecker.Companion, (Collection)types, null, 2, null);
        ExpectActualUtilsKt.showInaccessibleDeclarationError$default(psiElement, KotlinBundle.message((String)"some.types.are.not.accessible.from.0.1", (Object[])objectArray), null, 4, null);
        return false;
    }

    public static /* synthetic */ boolean isCorrectAndHaveAccessibleModifiers$default(TypeAccessibilityChecker typeAccessibilityChecker, KtNamedDeclaration ktNamedDeclaration, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ExpectActualUtilsKt.isCorrectAndHaveAccessibleModifiers(typeAccessibilityChecker, ktNamedDeclaration, bl);
    }

    private static final boolean anyInaccessibleModifier(KtModifierListOwner $this$anyInaccessibleModifier, Collection<KtModifierKeywordToken> modifiers, boolean showErrorHint) {
        for (KtModifierKeywordToken modifier : modifiers) {
            if (!$this$anyInaccessibleModifier.hasModifier(modifier)) continue;
            if (showErrorHint) {
                Object[] objectArray = new Object[]{modifier};
                ExpectActualUtilsKt.showInaccessibleDeclarationError$default((PsiElement)$this$anyInaccessibleModifier, KotlinBundle.message((String)"the.declaration.has.0.modifier", (Object[])objectArray), null, 4, null);
            }
            return true;
        }
        return false;
    }

    public static final void showInaccessibleDeclarationError(@NotNull PsiElement element, @NotNull String message2, @Nullable Editor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Editor editor2 = editor;
            if (editor2 == null) break block0;
            Editor it = editor2;
            boolean bl = false;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            IntroduceUtilsKt.showErrorHint(project, editor, EscapeXMLKt.escapeXml(message2), KotlinBundle.message((String)"inaccessible.declaration", (Object[])new Object[0]));
        }
    }

    public static /* synthetic */ void showInaccessibleDeclarationError$default(PsiElement psiElement, String string, Editor editor, int n, Object object) {
        if ((n & 4) != 0) {
            editor = EditorUtilsKt.findExistingEditor(psiElement);
        }
        ExpectActualUtilsKt.showInaccessibleDeclarationError(psiElement, string, editor);
    }

    @NotNull
    public static final String typesToString(@NotNull TypeAccessibilityChecker.Companion $this$typesToString, @NotNull Collection<FqName> types, @NotNull CharSequence separator) {
        Intrinsics.checkNotNullParameter((Object)$this$typesToString, (String)"<this>");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)types), (CharSequence)separator, null, null, (int)0, null, ExpectActualUtilsKt::typesToString$lambda$0, (int)30, null);
    }

    public static /* synthetic */ String typesToString$default(TypeAccessibilityChecker.Companion companion, Collection collection, CharSequence charSequence, int n, Object object) {
        if ((n & 2) != 0) {
            charSequence = "\n";
        }
        return ExpectActualUtilsKt.typesToString(companion, collection, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> findAndApplyExistingClasses(@NotNull TypeAccessibilityChecker $this$findAndApplyExistingClasses, @NotNull Collection<? extends KtNamedDeclaration> elements) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findAndApplyExistingClasses, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$filterIsInstance$iv = elements;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classes = (List)destination$iv$iv;
        while (!((Collection)classes).isEmpty()) {
            void $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = classes;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Iterable<String> destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtClassOrObject it = (KtClassOrObject)element$iv$iv;
                boolean bl2 = false;
                FqName fqName2 = it.getFqName();
                if ((fqName2 != null ? fqName2.asString() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            HashSet existingNames = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
            $this$findAndApplyExistingClasses.setExistingTypeNames(existingNames);
            Iterable $this$filter$iv = classes;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv$iv;
                boolean bl = false;
                if (!ExpectActualUtilsKt.isCorrectAndHaveAccessibleModifiers$default($this$findAndApplyExistingClasses, (KtNamedDeclaration)it, false, 2, null)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List newExistingClasses = (List)destination$iv$iv3;
            if (classes.size() == newExistingClasses.size()) {
                return existingNames;
            }
            classes = newExistingClasses;
        }
        return $this$findAndApplyExistingClasses.getExistingTypeNames();
    }

    private static final <D extends KtNamedDeclaration> void generateExpectOrActualInFile$lambda$0(Function4<? super KtPsiFactory, ? super Project, ? super TypeAccessibilityChecker, ? super D, ? extends D> $generateIt, KtPsiFactory factory2, Project $project, Module $module, D $element, Editor $editor, SmartPsiElementPointer<KtFile> targetFilePointer, KtFile $originalFile, SmartPsiElementPointer<KtClassOrObject> targetClassPointer) {
        block5: {
            KtNamedDeclaration ktNamedDeclaration;
            try {
                ktNamedDeclaration = (KtNamedDeclaration)$generateIt.invoke((Object)factory2, (Object)$project, (Object)TypeAccessibilityChecker.Companion.create$default(TypeAccessibilityChecker.Companion, $project, $module, null, 4, null), $element);
            }
            catch (KotlinTypeInaccessibleException e) {
                if ($editor != null) {
                    Object[] objectArray = new Object[]{CreateClassUtil.INSTANCE.getTypeDescription($element), e.getMessage()};
                    IntroduceUtilsKt.showErrorHint($project, $editor, EscapeXMLKt.escapeXml(KotlinBundle.message((String)"fix.create.declaration.error", (Object[])objectArray)), KotlinBundle.message((String)"fix.create.declaration.error.inaccessible.type", (Object[])new Object[0]));
                }
                ktNamedDeclaration = null;
            }
            KtNamedDeclaration ktNamedDeclaration2 = ktNamedDeclaration;
            if (ktNamedDeclaration2 == null) {
                return;
            }
            KtNamedDeclaration generated = ktNamedDeclaration2;
            KtElement ktElement = (KtElement)ApplicationUtilsKt.executeWriteCommand($project, KotlinBundle.message((String)"fix.create.expect.actual", (Object[])new Object[0]), null, () -> ExpectActualUtilsKt.generateExpectOrActualInFile$lambda$0$lambda$1(targetFilePointer, $originalFile, factory2, targetClassPointer, generated));
            if (ktElement == null) {
                return;
            }
            KtElement shortened = ktElement;
            Editor editor = EditorHelper.openInEditor((PsiElement)((PsiElement)shortened));
            if (editor == null || (editor = editor.getCaretModel()) == null) break block5;
            KtNamedDeclaration ktNamedDeclaration3 = shortened instanceof KtNamedDeclaration ? (KtNamedDeclaration)shortened : null;
            editor.moveToOffset(ktNamedDeclaration3 != null && (ktNamedDeclaration3 = ktNamedDeclaration3.getNameIdentifier()) != null ? PsiUtilsKt.getStartOffset((PsiElement)ktNamedDeclaration3) : PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)shortened)), true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final KtElement generateExpectOrActualInFile$lambda$0$lambda$1(SmartPsiElementPointer $targetFilePointer, KtFile $originalFile, KtPsiFactory $factory, SmartPsiElementPointer $targetClassPointer, KtNamedDeclaration $generated) {
        PsiElement psiElement;
        KtClassOrObject newPackageDirective;
        KtPackageDirective packageDirective;
        KtFile ktFile2 = (KtFile)$targetFilePointer.getElement();
        if (ktFile2 == null) {
            return null;
        }
        KtFile resultTargetFile = ktFile2;
        KtPackageDirective ktPackageDirective = resultTargetFile.getPackageDirective();
        KtPackageDirective ktPackageDirective2 = $originalFile.getPackageDirective();
        if (!Intrinsics.areEqual((Object)(ktPackageDirective != null ? ktPackageDirective.getFqName() : null), (Object)(ktPackageDirective2 != null ? ktPackageDirective2.getFqName() : null)) && resultTargetFile.getDeclarations().isEmpty() && (packageDirective = $originalFile.getPackageDirective()) != null) {
            KtPackageDirective oldPackageDirective = resultTargetFile.getPackageDirective();
            PsiElement psiElement2 = packageDirective.copy();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPackageDirective");
            newPackageDirective = (KtPackageDirective)psiElement2;
            if (oldPackageDirective != null) {
                String string = oldPackageDirective.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (((CharSequence)string).length() == 0) {
                    KtImportList ktImportList = resultTargetFile.getImportList();
                    resultTargetFile.addAfter($factory.createNewLine(2), (PsiElement)(ktImportList != null ? (KtElementImplStub)ktImportList : (KtElementImplStub)oldPackageDirective));
                }
                v6 = oldPackageDirective.replace((PsiElement)newPackageDirective);
            } else {
                v6 = resultTargetFile.add((PsiElement)newPackageDirective);
            }
        }
        SmartPsiElementPointer smartPsiElementPointer = $targetClassPointer;
        KtClassOrObject resultTargetClass = smartPsiElementPointer != null ? (KtClassOrObject)smartPsiElementPointer.getElement() : null;
        if (resultTargetClass != null) {
            if ($generated instanceof KtPrimaryConstructor && resultTargetClass instanceof KtClass) {
                psiElement = KtClassKt.createPrimaryConstructorIfAbsent((KtClass)((KtClass)resultTargetClass)).replace((PsiElement)$generated);
            } else {
                PsiElement anchor$iv;
                void this_$iv;
                newPackageDirective = resultTargetClass;
                Intrinsics.checkNotNull((Object)$generated, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                KtDeclaration declaration$iv = (KtDeclaration)$generated;
                boolean $i$f$addDeclaration = false;
                KtClassBody body$iv = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)this_$iv);
                PsiElement psiElement3 = body$iv.getRBrace();
                if (psiElement3 == null) {
                    PsiElement psiElement4 = body$iv.getLastChild();
                    psiElement3 = psiElement4;
                    Intrinsics.checkNotNull((Object)psiElement4);
                }
                Class[] classArray = new Class[]{PsiWhiteSpace.class};
                PsiElement psiElement5 = anchor$iv = PsiTreeUtil.skipSiblingsBackward((PsiElement)psiElement3, (Class[])classArray);
                PsiElement psiElement6 = (psiElement5 != null ? psiElement5.getNextSibling() : null) instanceof PsiErrorElement ? body$iv.addBefore((PsiElement)declaration$iv, anchor$iv) : body$iv.addAfter((PsiElement)declaration$iv, anchor$iv);
                if (psiElement6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                }
                psiElement = (PsiElement)((KtDeclaration)((KtNamedDeclaration)psiElement6));
            }
        } else {
            resultTargetFile.add($factory.createNewLine(1));
            PsiElement psiElement7 = resultTargetFile.add((PsiElement)$generated);
            Intrinsics.checkNotNull((Object)psiElement7, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            psiElement = (PsiElement)((KtElement)psiElement7);
        }
        PsiElement generatedDeclaration = psiElement;
        Intrinsics.checkNotNull((Object)generatedDeclaration);
        PsiElement psiElement8 = GenericPsiUtils.reformatted$default(generatedDeclaration, false, 1, null);
        Intrinsics.checkNotNull((Object)psiElement8, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        return ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement8, null, 2, null);
    }

    private static final CharSequence typesToString$lambda$0(FqName it) {
        Object object = it;
        return object != null && (object = object.shortName()) != null && (object = object.asString()) != null ? (CharSequence)object : (CharSequence)"<Unknown>";
    }

    static {
        Object[] objectArray = new KtModifierKeywordToken[]{KtTokens.PRIVATE_KEYWORD, KtTokens.CONST_KEYWORD, KtTokens.LATEINIT_KEYWORD};
        INACCESSIBLE_MODIFIERS = CollectionsKt.listOf((Object[])objectArray);
    }
}

