/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.templates;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.templates.FileDescriptor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileTemplateDescriptor;", "Lorg/jetbrains/kotlin/tools/projectWizard/templates/FileDescriptor;", "templateId", "", "relativePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "(Ljava/lang/String;)V", "getTemplateId", "()Ljava/lang/String;", "getRelativePath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.kotlin.projectWizard.core"})
public final class FileTemplateDescriptor
extends FileDescriptor {
    @NotNull
    private final String templateId;
    @Nullable
    private final Path relativePath;

    public FileTemplateDescriptor(@NonNls @NotNull String templateId, @Nullable Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        super(null);
        this.templateId = templateId;
        this.relativePath = relativePath;
    }

    @NotNull
    public final String getTemplateId() {
        return this.templateId;
    }

    @Override
    @Nullable
    public Path getRelativePath() {
        return this.relativePath;
    }

    public FileTemplateDescriptor(@NotNull String templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        this(templateId, UtilsKt.asPath(StringsKt.removeSuffix((String)((Object)Paths.get(templateId, new String[0]).getFileName()).toString(), (CharSequence)".vm")));
    }

    @NotNull
    public final String component1() {
        return this.templateId;
    }

    @Nullable
    public final Path component2() {
        return this.relativePath;
    }

    @NotNull
    public final FileTemplateDescriptor copy(@NonNls @NotNull String templateId, @Nullable Path relativePath) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        return new FileTemplateDescriptor(templateId, relativePath);
    }

    public static /* synthetic */ FileTemplateDescriptor copy$default(FileTemplateDescriptor fileTemplateDescriptor, String string, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            string = fileTemplateDescriptor.templateId;
        }
        if ((n & 2) != 0) {
            path2 = fileTemplateDescriptor.relativePath;
        }
        return fileTemplateDescriptor.copy(string, path2);
    }

    @NotNull
    public String toString() {
        return "FileTemplateDescriptor(templateId=" + this.templateId + ", relativePath=" + this.relativePath + ")";
    }

    public int hashCode() {
        int result2 = this.templateId.hashCode();
        result2 = result2 * 31 + (this.relativePath == null ? 0 : ((Object)this.relativePath).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileTemplateDescriptor)) {
            return false;
        }
        FileTemplateDescriptor fileTemplateDescriptor = (FileTemplateDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.templateId, (Object)fileTemplateDescriptor.templateId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.relativePath, (Object)fileTemplateDescriptor.relativePath);
    }
}

