/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.storage.internals.checkpoint.PartitionMetadata;

public class PartitionMetadataReadBuffer {
    private static final Pattern WHITE_SPACES_PATTERN = Pattern.compile(":\\s+");
    private final String location;
    private final BufferedReader reader;

    public PartitionMetadataReadBuffer(String location, BufferedReader reader) {
        this.location = location;
        this.reader = reader;
    }

    PartitionMetadata read() throws IOException {
        String line = null;
        try {
            line = this.reader.readLine();
            String[] versionArr = WHITE_SPACES_PATTERN.split(line);
            if (versionArr.length == 2) {
                int version = Integer.parseInt(versionArr[1]);
                if (version >= 0) {
                    line = this.reader.readLine();
                    String[] topicIdArr = WHITE_SPACES_PATTERN.split(line);
                    if (topicIdArr.length == 2) {
                        Uuid metadataTopicId = Uuid.fromString((String)topicIdArr[1]);
                        if (metadataTopicId.equals((Object)Uuid.ZERO_UUID)) {
                            throw new IOException("Invalid topic ID in partition metadata file (" + this.location + ")");
                        }
                        return new PartitionMetadata(version, metadataTopicId);
                    }
                    throw this.malformedLineException(line);
                }
                throw new IOException("Unrecognized version of partition metadata file (" + this.location + "): " + version);
            }
            throw this.malformedLineException(line);
        }
        catch (NumberFormatException e) {
            throw this.malformedLineException(line, e);
        }
    }

    private IOException malformedLineException(String line) {
        return new IOException(String.format("Malformed line in partition metadata file [%s]: %s", this.location, line));
    }

    private IOException malformedLineException(String line, Exception e) {
        return new IOException(String.format("Malformed line in partition metadata file [%s]: %s", this.location, line), e);
    }
}

