/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

public final class Booleans {
    private Booleans() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static boolean parseBoolean(char[] text, int offset, int length, boolean defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        switch (length) {
            case 0: {
                return defaultValue;
            }
            default: {
                break;
            }
            case 4: {
                if (text[offset] != 't' || text[offset + 1] != 'r' || text[offset + 2] != 'u' || text[offset + 3] != 'e') break;
                return true;
            }
            case 5: {
                if (text[offset] != 'f' || text[offset + 1] != 'a' || text[offset + 2] != 'l' || text[offset + 3] != 's' || text[offset + 4] != 'e') break;
                return false;
            }
        }
        throw new IllegalArgumentException("Failed to parse value [" + new String(text, offset, length) + "] as only [true] or [false] are allowed.");
    }

    public static boolean isBoolean(char[] text, int offset, int length) {
        if (text == null) {
            return false;
        }
        switch (length) {
            default: {
                return false;
            }
            case 4: {
                return text[offset] == 't' && text[offset + 1] == 'r' && text[offset + 2] == 'u' && text[offset + 3] == 'e';
            }
            case 5: 
        }
        return text[offset] == 'f' && text[offset + 1] == 'a' && text[offset + 2] == 'l' && text[offset + 3] == 's' && text[offset + 4] == 'e';
    }

    public static boolean isBoolean(String value) {
        return Booleans.isFalse(value) || Booleans.isTrue(value);
    }

    public static boolean parseBoolean(String value) {
        if (Booleans.isFalse(value)) {
            return false;
        }
        if (Booleans.isTrue(value)) {
            return true;
        }
        throw new IllegalArgumentException("Failed to parse value [" + value + "] as only [true] or [false] are allowed.");
    }

    @Deprecated
    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (value == null || value.isBlank()) {
            return defaultValue;
        }
        return Booleans.parseBoolean(value);
    }

    @Deprecated
    public static Boolean parseBoolean(String value, Boolean defaultValue) {
        if (value == null || value.isBlank()) {
            return defaultValue;
        }
        return Booleans.parseBoolean(value);
    }

    public static boolean parseBooleanStrict(String value, boolean defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Booleans.parseBoolean(value);
    }

    public static boolean isFalse(String value) {
        return "false".equals(value);
    }

    public static boolean isTrue(String value) {
        return "true".equals(value);
    }
}

