/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.analysis;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.opensearch.sql.calcite.utils.WildcardUtils;

public class FieldResolutionResult {
    @NonNull
    private final Set<String> regularFields;
    @NonNull
    private final Wildcard wildcard;
    static Wildcard ANY_WILDCARD = new Wildcard(){

        @Override
        public boolean matches(String fieldName) {
            return true;
        }

        public String toString() {
            return "*";
        }

        @Override
        public Wildcard and(Wildcard other) {
            return other;
        }

        @Override
        public Wildcard or(Wildcard other) {
            return this;
        }
    };
    static Wildcard NULL_WILDCARD = new Wildcard(){

        @Override
        public boolean matches(String fieldName) {
            return false;
        }

        public String toString() {
            return "";
        }

        @Override
        public Wildcard and(Wildcard other) {
            return this;
        }

        @Override
        public Wildcard or(Wildcard other) {
            return other;
        }
    };

    public FieldResolutionResult(Collection<String> regularFields) {
        this.regularFields = new HashSet<String>(regularFields);
        this.wildcard = NULL_WILDCARD;
    }

    public FieldResolutionResult(Collection<String> regularFields, Wildcard wildcard) {
        this.regularFields = new HashSet<String>(regularFields);
        this.wildcard = wildcard;
    }

    public FieldResolutionResult(Collection<String> regularFields, String wildcard) {
        this.regularFields = new HashSet<String>(regularFields);
        this.wildcard = FieldResolutionResult.getWildcard(wildcard);
    }

    private static Wildcard getWildcard(String wildcard) {
        if (wildcard == null || wildcard.isEmpty()) {
            return NULL_WILDCARD;
        }
        if (wildcard.equals("*")) {
            return ANY_WILDCARD;
        }
        return new SingleWildcard(wildcard);
    }

    public FieldResolutionResult(Collection<String> regularFields, Collection<String> wildcards) {
        this.regularFields = new HashSet<String>(regularFields);
        this.wildcard = FieldResolutionResult.createOrWildcard(wildcards);
    }

    private static Wildcard createOrWildcard(Collection<String> patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return NULL_WILDCARD;
        }
        if (patterns.size() == 1) {
            return FieldResolutionResult.getWildcard(patterns.iterator().next());
        }
        List<Wildcard> wildcards = patterns.stream().sorted().map(SingleWildcard::new).collect(Collectors.toList());
        return new OrWildcard(wildcards);
    }

    public Set<String> getRegularFieldsUnmodifiable() {
        return Collections.unmodifiableSet(this.regularFields);
    }

    public boolean hasWildcards() {
        return this.wildcard != NULL_WILDCARD;
    }

    public boolean hasPartialWildcards() {
        return this.wildcard != NULL_WILDCARD && this.wildcard != ANY_WILDCARD;
    }

    public boolean hasRegularFields() {
        return !this.regularFields.isEmpty();
    }

    public FieldResolutionResult exclude(Collection<String> fields) {
        HashSet<String> combinedFields = new HashSet<String>(this.regularFields);
        combinedFields.removeAll(fields);
        return new FieldResolutionResult(combinedFields, this.wildcard);
    }

    public FieldResolutionResult or(Collection<String> fields) {
        HashSet<String> combinedFields = new HashSet<String>(this.regularFields);
        combinedFields.addAll(fields);
        return new FieldResolutionResult(combinedFields, this.wildcard);
    }

    private Set<String> and(Collection<String> fields) {
        return fields.stream().filter(field -> this.getRegularFields().contains(field) || this.wildcard.matches((String)field)).collect(Collectors.toSet());
    }

    public FieldResolutionResult and(FieldResolutionResult other) {
        HashSet<String> combinedFields = new HashSet<String>();
        combinedFields.addAll(this.and(other.regularFields));
        combinedFields.addAll(other.and(this.regularFields));
        Wildcard combinedWildcard = this.wildcard.and(other.wildcard);
        return new FieldResolutionResult(combinedFields, combinedWildcard);
    }

    @NonNull
    @Generated
    public Set<String> getRegularFields() {
        return this.regularFields;
    }

    @NonNull
    @Generated
    public Wildcard getWildcard() {
        return this.wildcard;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldResolutionResult)) {
            return false;
        }
        FieldResolutionResult other = (FieldResolutionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$regularFields = this.getRegularFields();
        Set<String> other$regularFields = other.getRegularFields();
        if (this$regularFields == null ? other$regularFields != null : !((Object)this$regularFields).equals(other$regularFields)) {
            return false;
        }
        Wildcard this$wildcard = this.getWildcard();
        Wildcard other$wildcard = other.getWildcard();
        return !(this$wildcard == null ? other$wildcard != null : !this$wildcard.equals(other$wildcard));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldResolutionResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $regularFields = this.getRegularFields();
        result = result * 59 + ($regularFields == null ? 43 : ((Object)$regularFields).hashCode());
        Wildcard $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : $wildcard.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FieldResolutionResult(regularFields=" + String.valueOf(this.getRegularFields()) + ", wildcard=" + String.valueOf(this.getWildcard()) + ")";
    }

    public static interface Wildcard {
        public boolean matches(String var1);

        default public Wildcard and(Wildcard other) {
            return new AndWildcard(this, other);
        }

        default public Wildcard or(Wildcard other) {
            return new OrWildcard(this, other);
        }
    }

    static final class SingleWildcard
    implements Wildcard {
        private final String pattern;

        @Override
        public boolean matches(String fieldName) {
            return WildcardUtils.matchesWildcardPattern(this.pattern, fieldName);
        }

        public String toString() {
            return this.pattern;
        }

        @Generated
        public SingleWildcard(String pattern) {
            this.pattern = pattern;
        }

        @Generated
        public String getPattern() {
            return this.pattern;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleWildcard)) {
                return false;
            }
            SingleWildcard other = (SingleWildcard)o;
            String this$pattern = this.getPattern();
            String other$pattern = other.getPattern();
            return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
            return result;
        }
    }

    static final class OrWildcard
    implements Wildcard {
        private final List<Wildcard> patterns;

        public OrWildcard(Wildcard ... patterns) {
            this.patterns = List.of(patterns);
        }

        public OrWildcard(Collection<Wildcard> patterns) {
            this.patterns = List.copyOf(patterns);
        }

        @Override
        public boolean matches(String fieldName) {
            return this.patterns.stream().anyMatch(p -> p.matches(fieldName));
        }

        public String toString() {
            return this.patterns.stream().map((Function<Wildcard, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/opensearch/sql/ast/analysis/FieldResolutionResult$Wildcard;)Ljava/lang/String;)()).collect(Collectors.joining(" | "));
        }

        @Override
        public Wildcard or(Wildcard other) {
            if (other instanceof SingleWildcard) {
                ImmutableList newPatterns = ImmutableList.builder().addAll(this.patterns).add((Object)other).build();
                return new OrWildcard((Collection<Wildcard>)newPatterns);
            }
            if (other == NULL_WILDCARD) {
                return this;
            }
            if (other == ANY_WILDCARD) {
                return ANY_WILDCARD;
            }
            return Wildcard.super.or(other);
        }

        @Generated
        public List<Wildcard> getPatterns() {
            return this.patterns;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrWildcard)) {
                return false;
            }
            OrWildcard other = (OrWildcard)o;
            List<Wildcard> this$patterns = this.getPatterns();
            List<Wildcard> other$patterns = other.getPatterns();
            return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Wildcard> $patterns = this.getPatterns();
            result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
            return result;
        }
    }

    static final class AndWildcard
    implements Wildcard {
        private final List<Wildcard> patterns;

        public AndWildcard(Wildcard ... patterns) {
            this.patterns = List.of(patterns);
        }

        public AndWildcard(Collection<Wildcard> patterns) {
            this.patterns = List.copyOf(patterns);
        }

        @Override
        public boolean matches(String fieldName) {
            return this.patterns.stream().allMatch(p -> p.matches(fieldName));
        }

        public String toString() {
            return this.patterns.stream().map(p -> "(" + p.toString() + ")").collect(Collectors.joining(" & "));
        }

        @Override
        public Wildcard and(Wildcard other) {
            if (other instanceof SingleWildcard) {
                ImmutableList newPatterns = ImmutableList.builder().addAll(this.patterns).add((Object)other).build();
                return new AndWildcard((Collection<Wildcard>)newPatterns);
            }
            if (other == NULL_WILDCARD) {
                return NULL_WILDCARD;
            }
            if (other == ANY_WILDCARD) {
                return this;
            }
            return Wildcard.super.and(other);
        }

        @Generated
        public List<Wildcard> getPatterns() {
            return this.patterns;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AndWildcard)) {
                return false;
            }
            AndWildcard other = (AndWildcard)o;
            List<Wildcard> this$patterns = this.getPatterns();
            List<Wildcard> other$patterns = other.getPatterns();
            return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Wildcard> $patterns = this.getPatterns();
            result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
            return result;
        }
    }
}

