/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.IndicesRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.index.Index;
import org.opensearch.search.pipeline.SearchPipelineService;

public class KNNClusterUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNClusterUtil.class);
    private ClusterService clusterService;
    private static KNNClusterUtil instance;
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private SearchPipelineService searchPipelineService;

    public static synchronized KNNClusterUtil instance() {
        if (instance == null) {
            instance = new KNNClusterUtil();
        }
        return instance;
    }

    public void initialize(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public Version getClusterMinVersion() {
        try {
            return this.clusterService.state().getNodes().getMinNodeVersion();
        }
        catch (Exception exception) {
            log.error(String.format("Failed to get cluster minimum node version, returning current node version %s instead.", Version.CURRENT), (Throwable)exception);
            return Version.CURRENT;
        }
    }

    public List<IndexMetadata> getIndexMetadataList(@NonNull IndicesRequest searchRequest) {
        if (searchRequest == null) {
            throw new NullPointerException("searchRequest is marked non-null but is null");
        }
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(this.clusterService.state(), searchRequest);
        return Arrays.stream(concreteIndices).map(concreteIndex -> this.clusterService.state().metadata().index(concreteIndex)).collect(Collectors.toList());
    }

    public boolean isSystemGeneratedSearchFactoryEnabled(String factoryName) {
        if (this.searchPipelineService == null) {
            throw new IllegalStateException("search pipeline service is not initialized in the KNN cluster util.");
        }
        return this.searchPipelineService.isSystemGeneratedFactoryEnabled(factoryName);
    }

    @Generated
    private KNNClusterUtil() {
    }

    @Generated
    public void setSearchPipelineService(SearchPipelineService searchPipelineService) {
        this.searchPipelineService = searchPipelineService;
    }
}

