/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.BucketPathAggregation;
import org.opensearch.client.opensearch._types.aggregations.GapPolicy;

public abstract class PipelineAggregationBase
extends BucketPathAggregation {
    @Nullable
    private final String format;
    @Nullable
    private final GapPolicy gapPolicy;

    protected PipelineAggregationBase(AbstractBuilder<?> builder) {
        super((BucketPathAggregation.AbstractBuilder<?>)builder);
        this.format = ((AbstractBuilder)builder).format;
        this.gapPolicy = ((AbstractBuilder)builder).gapPolicy;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.gapPolicy != null) {
            generator.writeKey("gap_policy");
            this.gapPolicy.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPipelineAggregationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        PipelineAggregationBase.setupBucketPathAggregationDeserializer(op);
        op.add(AbstractBuilder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(AbstractBuilder::gapPolicy, GapPolicy._DESERIALIZER, "gap_policy");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.format);
        result = 31 * result + Objects.hashCode(this.gapPolicy);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineAggregationBase other = (PipelineAggregationBase)o;
        return Objects.equals(this.format, other.format) && Objects.equals(this.gapPolicy, other.gapPolicy);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends BucketPathAggregation.AbstractBuilder<BuilderT> {
        @Nullable
        private String format;
        @Nullable
        private GapPolicy gapPolicy;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(PipelineAggregationBase o) {
            super(o);
            this.format = o.format;
            this.gapPolicy = o.gapPolicy;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.format = o.format;
            this.gapPolicy = o.gapPolicy;
        }

        @Nonnull
        public final BuilderT format(@Nullable String value) {
            this.format = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT gapPolicy(@Nullable GapPolicy value) {
            this.gapPolicy = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

