/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.ssl;

import java.net.IDN;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Contract;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class SpkiPinningClientTlsStrategy
extends DefaultClientTlsStrategy {
    private static final String PIN_PREFIX = "sha256/";
    private static final int SHA256_LEN = 32;
    private final List<Rule> rules;

    private SpkiPinningClientTlsStrategy(SSLContext sslContext, List<Rule> rules) {
        super(sslContext);
        this.rules = Collections.unmodifiableList(new ArrayList<Rule>(rules));
    }

    @Override
    protected void verifySession(String hostname, SSLSession sslSession) throws SSLException {
        String host;
        try {
            host = IDN.toASCII(hostname == null ? "" : hostname).toLowerCase(Locale.ROOT);
        }
        catch (IllegalArgumentException e) {
            throw new SSLException("Invalid IDN host: " + hostname, e);
        }
        super.verifySession(host, sslSession);
        this.enforcePins(host, sslSession);
    }

    void enforcePins(String hostname, SSLSession sslSession) throws SSLException {
        List<Rule> matched = this.matchedRules(hostname);
        if (matched.isEmpty()) {
            return;
        }
        byte[][] peerSpkiHashes = SpkiPinningClientTlsStrategy.chainSpkiSha256(sslSession);
        for (int i = 0; i < peerSpkiHashes.length; ++i) {
            ByteArrayKey key = new ByteArrayKey(peerSpkiHashes[i]);
            for (int r = 0; r < matched.size(); ++r) {
                if (!matched.get((int)r).pins.contains(key)) continue;
                return;
            }
        }
        throw new SSLException("SPKI pinning failure for " + hostname + "; peer pins: " + SpkiPinningClientTlsStrategy.peerPinsForLog(peerSpkiHashes) + "; configured pins: " + SpkiPinningClientTlsStrategy.configuredPinsFor(matched));
    }

    public static Builder newBuilder(SSLContext sslContext) {
        return new Builder(sslContext);
    }

    private List<Rule> matchedRules(String host) {
        ArrayList<Rule> out = new ArrayList<Rule>();
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule r = this.rules.get(i);
            if (!r.matches(host)) continue;
            out.add(r);
        }
        return out;
    }

    private static byte[][] chainSpkiSha256(SSLSession session) throws SSLException {
        Certificate[] chain = session.getPeerCertificates();
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            ArrayList<byte[]> out = new ArrayList<byte[]>(chain.length);
            for (int i = 0; i < chain.length; ++i) {
                Certificate c = chain[i];
                if (!(c instanceof X509Certificate)) continue;
                byte[] spki = ((X509Certificate)c).getPublicKey().getEncoded();
                out.add(sha256.digest(spki));
            }
            if (out.isEmpty()) {
                throw new SSLException("No X509Certificate in peer chain");
            }
            return (byte[][])out.toArray((T[])new byte[out.size()][]);
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException("Cannot compute SPKI sha256", e);
        }
    }

    private static String configuredPinsFor(List<Rule> rules) {
        ArrayList<String> pins = new ArrayList<String>();
        for (int i = 0; i < rules.size(); ++i) {
            for (ByteArrayKey k : rules.get((int)i).pins) {
                pins.add(PIN_PREFIX + Base64.getEncoder().encodeToString(k.v));
            }
        }
        return ((Object)pins).toString();
    }

    private static String peerPinsForLog(byte[][] hashes) {
        ArrayList<String> pins = new ArrayList<String>(hashes.length);
        for (int i = 0; i < hashes.length; ++i) {
            pins.add(PIN_PREFIX + Base64.getEncoder().encodeToString(hashes[i]));
        }
        return ((Object)pins).toString();
    }

    public static final class Builder {
        private final SSLContext sslContext;
        private final List<Rule> rules = new ArrayList<Rule>();

        private Builder(SSLContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
        }

        public Builder add(String hostPattern, String ... pins) {
            if (pins == null || pins.length == 0) {
                throw new IllegalArgumentException("No pins supplied for " + hostPattern);
            }
            HashSet<ByteArrayKey> set = new HashSet<ByteArrayKey>(pins.length);
            for (int i = 0; i < pins.length; ++i) {
                set.add(Builder.parsePin(pins[i]));
            }
            this.rules.add(new Rule(hostPattern, set));
            return this;
        }

        public SpkiPinningClientTlsStrategy build() {
            return new SpkiPinningClientTlsStrategy(this.sslContext, this.rules);
        }

        private static ByteArrayKey parsePin(String s) {
            byte[] raw;
            if (s == null) {
                throw new IllegalArgumentException("Pin must not be null");
            }
            String t = s.trim();
            if (!t.regionMatches(true, 0, SpkiPinningClientTlsStrategy.PIN_PREFIX, 0, SpkiPinningClientTlsStrategy.PIN_PREFIX.length())) {
                throw new IllegalArgumentException("Only sha256 pins are supported: " + s);
            }
            String b64 = t.substring(SpkiPinningClientTlsStrategy.PIN_PREFIX.length()).trim();
            try {
                raw = Base64.getDecoder().decode(b64);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid Base64 in SPKI pin: " + s, e);
            }
            if (raw.length != 32) {
                throw new IllegalArgumentException("SPKI pin must be 32 bytes (SHA-256): " + s);
            }
            return new ByteArrayKey(raw);
        }
    }

    private static final class Rule {
        final String pattern;
        final boolean wildcard;
        final String tail;
        final Set<ByteArrayKey> pins;

        Rule(String pattern, Set<ByteArrayKey> pins) {
            String norm;
            if (pattern == null) {
                throw new IllegalArgumentException("Host pattern must not be null");
            }
            try {
                norm = IDN.toASCII(pattern).toLowerCase(Locale.ROOT);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid IDN host pattern: " + pattern, e);
            }
            if (norm.isEmpty()) {
                throw new IllegalArgumentException("Empty host pattern");
            }
            boolean wc = norm.startsWith("*.");
            if (wc && norm.indexOf(46, 2) < 0) {
                throw new IllegalArgumentException("Wildcard must be single-label: *.example.com");
            }
            if (pins == null || pins.isEmpty()) {
                throw new IllegalArgumentException("At least one SPKI pin is required for " + pattern);
            }
            this.pattern = norm;
            this.wildcard = wc;
            this.tail = wc ? norm.substring(1) : null;
            this.pins = Collections.unmodifiableSet(new HashSet<ByteArrayKey>(pins));
        }

        boolean matches(String host) {
            if (host == null || host.isEmpty()) {
                return false;
            }
            if (this.wildcard) {
                if (!host.endsWith(this.tail)) {
                    return false;
                }
                int boundary = host.length() - this.tail.length();
                if (boundary < 1) {
                    return false;
                }
                if (host.charAt(boundary) != '.') {
                    return false;
                }
                return host.indexOf(46, 0) == boundary;
            }
            return host.equals(this.pattern);
        }
    }

    private static final class ByteArrayKey {
        final byte[] v;
        private final int hash;

        ByteArrayKey(byte[] v) {
            this.v = Objects.requireNonNull(v, "bytes");
            int h = 1;
            for (int i = 0; i < v.length; ++i) {
                h = 31 * h + (v[i] & 0xFF);
            }
            this.hash = h;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteArrayKey)) {
                return false;
            }
            return MessageDigest.isEqual(this.v, ((ByteArrayKey)o).v);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

