/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.List;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.Hunspell;
import org.apache.lucene.analysis.hunspell.SortingStrategy;
import org.languagetool.rules.spelling.hunspell.HunspellDictionary;

public class HunspellFacade {
    public static void installLuceneHunspellToLanguageTool() {
        HunspellFacade.cleanTempDirRemnantsFromPreviousRuns();
        org.languagetool.rules.spelling.hunspell.Hunspell.setHunspellDictionaryFactory((dic, aff) -> {
            try {
                return HunspellFacade.loadLuceneHunspell(dic, aff);
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void cleanTempDirRemnantsFromPreviousRuns() {
        Path tempDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]);
        try {
            for (String dicName : List.of("en_US", "de_DE", "ru", "uk")) {
                Files.deleteIfExists(tempDir.resolve(dicName + ".dic"));
                Files.deleteIfExists(tempDir.resolve(dicName + ".aff"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static HunspellDictionary loadLuceneHunspell(Path dic, Path aff) throws IOException, ParseException {
        Dictionary dictionary = new Dictionary(Files.newInputStream(aff, new OpenOption[0]), List.of(Files.newInputStream(dic, new OpenOption[0])), false, SortingStrategy.inMemory());
        final Hunspell speller = new Hunspell(dictionary);
        return new HunspellDictionary(){

            public boolean spell(String word) {
                return speller.spell(word);
            }

            public void add(String word) {
                throw new UnsupportedOperationException();
            }

            public List<String> suggest(String word) {
                return speller.suggest(word);
            }

            public void close() {
            }

            public boolean isClosed() {
                return false;
            }
        };
    }
}

