/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Streams;

class ElementsSatisfyingConsumer<E> {
    private final List<E> elements;

    ElementsSatisfyingConsumer(Iterable<? extends E> actual, Consumer<? super E> assertions2) {
        this(ElementsSatisfyingConsumer.filterByPassingAssertions(actual, assertions2));
    }

    private static <E> List<E> filterByPassingAssertions(Iterable<? extends E> actual, Consumer<? super E> assertions2) {
        return Streams.stream(actual).filter(Iterables.byPassingAssertions(assertions2)).collect(Collectors.toList());
    }

    private ElementsSatisfyingConsumer(List<E> elements) {
        this.elements = elements;
    }

    List<E> getElements() {
        return this.elements;
    }

    ElementsSatisfyingConsumer<E> withoutElement(E element) {
        ArrayList<E> listWithoutElement = new ArrayList<E>(this.elements);
        ElementsSatisfyingConsumer.removeFirstReference(element, listWithoutElement);
        return new ElementsSatisfyingConsumer<E>(listWithoutElement);
    }

    private static void removeFirstReference(Object element, List<?> elements) {
        IntStream.range(0, elements.size()).filter(i2 -> elements.get(i2) == element).findFirst().ifPresent(elements::remove);
    }
}

