/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.run.ui.MutationSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.util.EventListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridDataHookUp<Row, Column>
extends MutationSupport<Row, Column> {
    @NotNull
    public Project getProject();

    @NotNull
    public GridPagingModel<Row, Column> getPageModel();

    public void updateFilterSortFully();

    @NotNull
    public Language getFilterSortLanguage();

    public boolean isFilterApplicable();

    @NotNull
    public String getFilterPrefix();

    @NotNull
    public String getFilterEmptyText();

    @Nullable
    public GridFilteringModel getFilteringModel();

    @NotNull
    public String getSortingPrefix();

    @NotNull
    public String getSortingEmptyText();

    @Nullable
    public GridSortingModel<Row, Column> getSortingModel();

    @Nullable
    public GridMutator<Row, Column> getMutator();

    @NotNull
    public GridLoader getLoader();

    public int getBusyCount();

    public boolean isReadOnly();

    default public boolean isForSingleSource() {
        return true;
    }

    public void addRequestListener(@NotNull RequestListener<Row, Column> var1, @NotNull Disposable var2);

    public static interface RequestListener<Row, Column>
    extends EventListener {
        public void error(@NotNull GridRequestSource var1, @NotNull ErrorInfo var2);

        public void updateCountReceived(@NotNull GridRequestSource var1, int var2);

        @ApiStatus.Experimental
        default public void requestStarted(@NotNull GridRequestSource source) {
            if (source == null) {
                RequestListener.$$$reportNull$$$0(0);
            }
        }

        @ApiStatus.Experimental
        default public void requestProgress(@NotNull GridRequestSource source, @NlsContexts.ProgressText @Nullable String progress) {
            if (source == null) {
                RequestListener.$$$reportNull$$$0(1);
            }
        }

        public void requestFinished(@NotNull GridRequestSource var1, boolean var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUp$RequestListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestProgress";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

