/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesBrowser;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.CompareWithLocalDialog;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsDiffUtil {
    @Nls
    @NotNull
    public static String getRevisionTitle(@NotNull @NlsSafe String revision, boolean localMark) {
        if (revision == null) {
            VcsDiffUtil.$$$reportNull$$$0(0);
        }
        String string = revision + (String)(localMark ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getRevisionTitle(@NotNull @NlsSafe String revision, @Nullable FilePath file, @Nullable FilePath baseFile) {
        boolean needFileName;
        if (revision == null) {
            VcsDiffUtil.$$$reportNull$$$0(2);
        }
        boolean bl = needFileName = file != null && !ChangesUtil.equalsCaseSensitive((FilePath)baseFile, (FilePath)file);
        if (!needFileName) {
            String string = revision;
            if (string == null) {
                VcsDiffUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String fileName = VcsDiffUtil.getRelativeFileName(baseFile, file);
        String string = revision.isEmpty() ? fileName : String.format("%s (%s)", revision, fileName);
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Deprecated
    public static void putFilePathsIntoChangeContext(@NotNull Change change, @NotNull Map<Key<?>, Object> context) {
        if (change == null) {
            VcsDiffUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            VcsDiffUtil.$$$reportNull$$$0(6);
        }
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        FilePath aFile = afterRevision == null ? null : afterRevision.getFile();
        FilePath bFile = beforeRevision == null ? null : beforeRevision.getFile();
        String afterRevisionName = afterRevision instanceof CurrentContentRevision ? VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) : VcsDiffUtil.getShortHash(afterRevision);
        context.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(afterRevisionName, aFile, null));
        context.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(beforeRevision, bFile, aFile));
    }

    @Nls
    @NotNull
    public static String getRevisionTitle(@Nullable ContentRevision revision, @Nullable FilePath file, @Nullable FilePath baseFile) {
        return VcsDiffUtil.getRevisionTitle(VcsDiffUtil.getShortHash(revision), file, baseFile);
    }

    @NlsSafe
    @NotNull
    private static String getShortHash(@Nullable ContentRevision revision) {
        if (revision == null) {
            return "";
        }
        String string = VcsUtil.getShortRevisionString((VcsRevisionNumber)revision.getRevisionNumber());
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String getRelativeFileName(@Nullable FilePath baseFile, @NotNull FilePath file) {
        if (file == null) {
            VcsDiffUtil.$$$reportNull$$$0(8);
        }
        if (baseFile == null || !baseFile.getName().equals(file.getName())) {
            String string = file.getName();
            if (string == null) {
                VcsDiffUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        FilePath aParentPath = baseFile.getParentPath();
        if (aParentPath == null) {
            String string = file.getName();
            if (string == null) {
                VcsDiffUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = VcsFileUtil.relativePath(aParentPath.getIOFile(), file.getIOFile());
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @RequiresEdt
    public static void showChangesDialog(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull List<? extends Change> changes) {
        if (project == null) {
            VcsDiffUtil.$$$reportNull$$$0(12);
        }
        if (title == null) {
            VcsDiffUtil.$$$reportNull$$$0(13);
        }
        if (changes == null) {
            VcsDiffUtil.$$$reportNull$$$0(14);
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setTitle(title);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        SimpleAsyncChangesBrowser changesBrowser = new SimpleAsyncChangesBrowser(project, false, true);
        changesBrowser.setChangesToDisplay(changes);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser);
        dialogBuilder.setPreferredFocusComponent(changesBrowser.getPreferredFocusedComponent());
        dialogBuilder.setDimensionServiceKey("VcsDiffUtil.ChangesDialog");
        dialogBuilder.addDisposable(() -> changesBrowser.shutdown());
        dialogBuilder.showNotModal();
    }

    @NotNull
    public static List<Change> createChangesWithCurrentContentForFile(@NotNull FilePath filePath, @Nullable ContentRevision beforeContentRevision) {
        if (filePath == null) {
            VcsDiffUtil.$$$reportNull$$$0(15);
        }
        List<Change> list = Collections.singletonList(new Change(beforeContentRevision, CurrentContentRevision.create((FilePath)filePath)));
        if (list == null) {
            VcsDiffUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    public static void showChangesWithWorkingDirLater(@NotNull Project project, @NotNull VirtualFile file, @NotNull VcsRevisionNumber targetRevNumber, @NotNull DiffProvider provider) {
        if (project == null) {
            VcsDiffUtil.$$$reportNull$$$0(17);
        }
        if (file == null) {
            VcsDiffUtil.$$$reportNull$$$0(18);
        }
        if (targetRevNumber == null) {
            VcsDiffUtil.$$$reportNull$$$0(19);
        }
        if (provider == null) {
            VcsDiffUtil.$$$reportNull$$$0(20);
        }
        String revNumTitle1 = VcsDiffUtil.getRevisionTitle(VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber), false);
        String revNumTitle2 = VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]);
        String dialogTitle = VcsBundle.message((String)"history.dialog.title.difference.between.versions.in", (Object[])new Object[]{revNumTitle1, revNumTitle2, file.getName()});
        CompareWithLocalDialog.showChanges(project, dialogTitle, CompareWithLocalDialog.LocalContent.AFTER, (ThrowableComputable<? extends Collection<Change>, ? extends VcsException>)((ThrowableComputable)() -> provider.compareWithWorkingDir(file, targetRevNumber)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 7, 9, 10, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/VcsDiffUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRevNumber";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/VcsDiffUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeFileName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangesWithCurrentContentForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionTitle";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putFilePathsIntoChangeContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFileName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showChangesDialog";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChangesWithCurrentContentForFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showChangesWithWorkingDirLater";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 7, 9, 10, 11, 16 -> new IllegalStateException(string);
        };
    }
}

