﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/forecast/ForecastService_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {
class CreateForecastResult {
 public:
  AWS_FORECASTSERVICE_API CreateForecastResult() = default;
  AWS_FORECASTSERVICE_API CreateForecastResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FORECASTSERVICE_API CreateForecastResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the forecast.</p>
   */
  inline const Aws::String& GetForecastArn() const { return m_forecastArn; }
  template <typename ForecastArnT = Aws::String>
  void SetForecastArn(ForecastArnT&& value) {
    m_forecastArnHasBeenSet = true;
    m_forecastArn = std::forward<ForecastArnT>(value);
  }
  template <typename ForecastArnT = Aws::String>
  CreateForecastResult& WithForecastArn(ForecastArnT&& value) {
    SetForecastArn(std::forward<ForecastArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateForecastResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_forecastArn;
  bool m_forecastArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
