﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/AppStatus.h>
#include <aws/sagemaker/model/AppType.h>
#include <aws/sagemaker/model/ResourceSpec.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {

/**
 * <p>Details about an Amazon SageMaker AI app.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AppDetails">AWS
 * API Reference</a></p>
 */
class AppDetails {
 public:
  AWS_SAGEMAKER_API AppDetails() = default;
  AWS_SAGEMAKER_API AppDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API AppDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SAGEMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The domain ID.</p>
   */
  inline const Aws::String& GetDomainId() const { return m_domainId; }
  inline bool DomainIdHasBeenSet() const { return m_domainIdHasBeenSet; }
  template <typename DomainIdT = Aws::String>
  void SetDomainId(DomainIdT&& value) {
    m_domainIdHasBeenSet = true;
    m_domainId = std::forward<DomainIdT>(value);
  }
  template <typename DomainIdT = Aws::String>
  AppDetails& WithDomainId(DomainIdT&& value) {
    SetDomainId(std::forward<DomainIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The user profile name.</p>
   */
  inline const Aws::String& GetUserProfileName() const { return m_userProfileName; }
  inline bool UserProfileNameHasBeenSet() const { return m_userProfileNameHasBeenSet; }
  template <typename UserProfileNameT = Aws::String>
  void SetUserProfileName(UserProfileNameT&& value) {
    m_userProfileNameHasBeenSet = true;
    m_userProfileName = std::forward<UserProfileNameT>(value);
  }
  template <typename UserProfileNameT = Aws::String>
  AppDetails& WithUserProfileName(UserProfileNameT&& value) {
    SetUserProfileName(std::forward<UserProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the space.</p>
   */
  inline const Aws::String& GetSpaceName() const { return m_spaceName; }
  inline bool SpaceNameHasBeenSet() const { return m_spaceNameHasBeenSet; }
  template <typename SpaceNameT = Aws::String>
  void SetSpaceName(SpaceNameT&& value) {
    m_spaceNameHasBeenSet = true;
    m_spaceName = std::forward<SpaceNameT>(value);
  }
  template <typename SpaceNameT = Aws::String>
  AppDetails& WithSpaceName(SpaceNameT&& value) {
    SetSpaceName(std::forward<SpaceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of app.</p>
   */
  inline AppType GetAppType() const { return m_appType; }
  inline bool AppTypeHasBeenSet() const { return m_appTypeHasBeenSet; }
  inline void SetAppType(AppType value) {
    m_appTypeHasBeenSet = true;
    m_appType = value;
  }
  inline AppDetails& WithAppType(AppType value) {
    SetAppType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the app.</p>
   */
  inline const Aws::String& GetAppName() const { return m_appName; }
  inline bool AppNameHasBeenSet() const { return m_appNameHasBeenSet; }
  template <typename AppNameT = Aws::String>
  void SetAppName(AppNameT&& value) {
    m_appNameHasBeenSet = true;
    m_appName = std::forward<AppNameT>(value);
  }
  template <typename AppNameT = Aws::String>
  AppDetails& WithAppName(AppNameT&& value) {
    SetAppName(std::forward<AppNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status.</p>
   */
  inline AppStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(AppStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline AppDetails& WithStatus(AppStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creation time.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  AppDetails& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResourceSpec& GetResourceSpec() const { return m_resourceSpec; }
  inline bool ResourceSpecHasBeenSet() const { return m_resourceSpecHasBeenSet; }
  template <typename ResourceSpecT = ResourceSpec>
  void SetResourceSpec(ResourceSpecT&& value) {
    m_resourceSpecHasBeenSet = true;
    m_resourceSpec = std::forward<ResourceSpecT>(value);
  }
  template <typename ResourceSpecT = ResourceSpec>
  AppDetails& WithResourceSpec(ResourceSpecT&& value) {
    SetResourceSpec(std::forward<ResourceSpecT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainId;

  Aws::String m_userProfileName;

  Aws::String m_spaceName;

  AppType m_appType{AppType::NOT_SET};

  Aws::String m_appName;

  AppStatus m_status{AppStatus::NOT_SET};

  Aws::Utils::DateTime m_creationTime{};

  ResourceSpec m_resourceSpec;
  bool m_domainIdHasBeenSet = false;
  bool m_userProfileNameHasBeenSet = false;
  bool m_spaceNameHasBeenSet = false;
  bool m_appTypeHasBeenSet = false;
  bool m_appNameHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_resourceSpecHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
