/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.components.FontProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class FontNameControlGroup
implements ControlGroup {
    static final String NODE_FONT_NAME = "nodefontname";
    private RevertingProperty mSetNodeFontName;
    private FontProperty mNodeFontName;
    private FontNameChangeListener propertyChangeListener;

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeFontName = new RevertingProperty();
        this.mNodeFontName = new FontProperty(NODE_FONT_NAME);
        this.propertyChangeListener = new FontNameChangeListener(this.mSetNodeFontName, (IPropertyControl)this.mNodeFontName);
        this.mSetNodeFontName.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeFontName.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeFontName.appendToForm(formBuilder);
        this.mSetNodeFontName.appendToForm(formBuilder);
    }

    private class FontNameChangeListener
    extends ControlGroupChangeListener {
        public FontNameChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setFontFamily(node, enabled ? FontNameControlGroup.this.mNodeFontName.getValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            String fontFamilyName = NodeStyleModel.getFontFamilyName((NodeModel)node);
            String viewFontFamilyName = styleController.getFontFamilyName(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            FontNameControlGroup.this.mSetNodeFontName.setValue(fontFamilyName != null);
            FontNameControlGroup.this.mNodeFontName.setValue(viewFontFamilyName);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)FontNameControlGroup.this.mSetNodeFontName);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)FontNameControlGroup.this.mNodeFontName);
        }
    }
}

