/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import javax.swing.SwingUtilities;
import org.freeplane.view.swing.map.outline.OutlineSelection;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.TreeNode;

class ExpansionControls {
    private final ScrollableTreePanel treePanel;
    private final OutlineSelection outlineSelection;

    ExpansionControls(ScrollableTreePanel treePanel, OutlineSelection outlineSelection) {
        this.treePanel = treePanel;
        this.outlineSelection = outlineSelection;
    }

    void expandNode(TreeNode node) {
        if (!node.isExpanded()) {
            node.expandNodeMore(1);
            this.refreshAfterExpansionChange();
        }
    }

    void collapseNode(TreeNode node) {
        if (node.isExpanded()) {
            int minimalLevel = this.treePanel.getDisplayMode().getMinimalOutlineLevel();
            if (node.getLevel() >= minimalLevel) {
                node.reduceNodeExpansion(0);
                this.selectParentIfNeeded();
                this.refreshAfterExpansionChange();
            } else {
                for (TreeNode child : node.getChildren()) {
                    this.collapseNode(child);
                }
            }
        }
    }

    void expandNodeMore(TreeNode node) {
        int currentLevel = node.getMaxExpansionLevel();
        node.expandNodeMore(currentLevel + 1);
        this.refreshAfterExpansionChange();
    }

    void reduceNodeExpansion(TreeNode node) {
        int minimalLevel;
        int currentLevel = node.getMaxExpansionLevel();
        if (currentLevel > (minimalLevel = this.treePanel.getDisplayMode().getMinimalOutlineLevel()) - node.getLevel()) {
            node.reduceNodeExpansion(currentLevel - 1);
            this.selectParentIfNeeded();
            this.refreshAfterExpansionChange();
        }
    }

    private void selectParentIfNeeded() {
        TreeNode selectedNode = this.outlineSelection.getSelectedNode();
        if (selectedNode != null && !selectedNode.isVisible()) {
            this.outlineSelection.selectNode(selectedNode.getParent());
        }
    }

    private void refreshAfterExpansionChange() {
        boolean wasFocused = this.treePanel.isNodeButtonFocused();
        this.treePanel.updateVisibleNodes(ScrollableTreePanel.ScrollMode.SINGLE_ITEM);
        SwingUtilities.invokeLater(() -> {
            if (wasFocused) {
                this.treePanel.focusSelectionButtonLater(true);
            } else {
                this.treePanel.synchronizeSelectionButton(false);
            }
        });
    }
}

