/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.action;

import ghidra.debug.api.action.AutoReadMemorySpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public interface AutoReadMemorySpecFactory
extends ExtensionPoint {
    public static AutoReadMemorySpec fromConfigName(String name) {
        for (AutoReadMemorySpecFactory factory : ClassSearcher.getInstances(AutoReadMemorySpecFactory.class)) {
            AutoReadMemorySpec spec = factory.parseSpec(name);
            if (spec == null) continue;
            return spec;
        }
        return null;
    }

    public static Map<String, AutoReadMemorySpec> allSuggested(PluginTool tool) {
        TreeMap<String, AutoReadMemorySpec> all = new TreeMap<String, AutoReadMemorySpec>();
        for (AutoReadMemorySpecFactory factory : ClassSearcher.getInstances(AutoReadMemorySpecFactory.class)) {
            for (AutoReadMemorySpec spec : factory.getSuggested(tool)) {
                if (spec.getMenuName() == null) continue;
                all.put(spec.getConfigName(), spec);
            }
        }
        return all;
    }

    public List<AutoReadMemorySpec> getSuggested(PluginTool var1);

    public AutoReadMemorySpec parseSpec(String var1);
}

