/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IndexRange;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.ObjectValueRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ObjectRangeMap<T> {
    private List<ObjectValueRange<T>> ranges = new ArrayList<ObjectValueRange<T>>();
    ObjectValueRange<T> lastRange;

    public IndexRangeIterator getIndexRangeIterator() {
        return new SimpleIndexRangeIterator();
    }

    public IndexRangeIterator getIndexRangeIterator(long start, long end) {
        return new RestrictedIndexRangeIterator(start, end);
    }

    public synchronized void setObject(long start, long end, T object) {
        this.lastRange = null;
        ObjectValueRange<T> newRange = new ObjectValueRange<T>(start, end, object);
        if (this.ranges.isEmpty()) {
            this.ranges.add(newRange);
            return;
        }
        int previousIndex = this.getPositionOfRangeBefore(newRange);
        if (previousIndex >= 0) {
            newRange = this.adjustPreviousRangeForOverlap(start, end, object, newRange, previousIndex);
        }
        int insertionIndex = Math.max(0, previousIndex + 1);
        long newEnd = newRange.getEnd();
        this.removeCompletelyOverlappedRanges(insertionIndex, newEnd);
        newRange = this.adjustRemainingRangeForOverlap(object, newRange, insertionIndex, newEnd);
        this.ranges.add(insertionIndex, newRange);
    }

    private ObjectValueRange<T> adjustRemainingRangeForOverlap(T object, ObjectValueRange<T> newRange, int insertionIndex, long newEnd) {
        if (insertionIndex >= this.ranges.size()) {
            return newRange;
        }
        ObjectValueRange<T> range = this.ranges.get(insertionIndex);
        if (range.getStart() > newEnd + 1L) {
            return newRange;
        }
        if (this.valuesEqual(range.getValue(), object)) {
            this.ranges.remove(insertionIndex);
            newRange = new ObjectValueRange<T>(newRange.getStart(), range.getEnd(), object);
        } else {
            this.ranges.set(insertionIndex, new ObjectValueRange<T>(newEnd + 1L, range.getEnd(), range.getValue()));
        }
        return newRange;
    }

    private void removeCompletelyOverlappedRanges(int insertionIndex, long newEnd) {
        while (insertionIndex < this.ranges.size()) {
            ObjectValueRange<T> range = this.ranges.get(insertionIndex);
            if (range.getEnd() > newEnd) {
                return;
            }
            this.ranges.remove(insertionIndex);
        }
    }

    private ObjectValueRange<T> adjustPreviousRangeForOverlap(long start, long end, T object, ObjectValueRange<T> newRange, int pos) {
        ObjectValueRange<T> previousRange = this.ranges.get(pos);
        if (previousRange.getEnd() < start - 1L) {
            return newRange;
        }
        long oldStart = previousRange.getStart();
        long oldEnd = previousRange.getEnd();
        T oldValue = previousRange.getValue();
        if (this.valuesEqual(previousRange.getValue(), object)) {
            this.ranges.remove(pos);
            newRange = new ObjectValueRange<T>(oldStart, Math.max(oldEnd, end), object);
        } else {
            this.ranges.set(pos, new ObjectValueRange<T>(oldStart, start - 1L, oldValue));
            if (previousRange.getEnd() > end) {
                this.ranges.add(pos + 1, new ObjectValueRange<T>(end + 1L, oldEnd, oldValue));
            }
        }
        return newRange;
    }

    public synchronized void clearRange(long start, long end) {
        ObjectValueRange<T> range;
        this.lastRange = null;
        int pos = this.getPositionOfRangeBefore(new ObjectValueRange<Object>(start, end, null));
        if (pos >= 0) {
            range = this.ranges.get(pos);
            if (range.getEnd() >= start) {
                this.ranges.set(pos, new ObjectValueRange<T>(range.getStart(), start - 1L, range.getValue()));
            }
            if (range.getEnd() > end) {
                this.ranges.add(pos + 1, new ObjectValueRange<T>(end + 1L, range.getEnd(), range.getValue()));
            }
        }
        pos = Math.max(0, pos + 1);
        while (pos < this.ranges.size()) {
            range = this.ranges.get(pos);
            if (range.getEnd() <= end) {
                this.ranges.remove(pos);
                continue;
            }
            if (range.getStart() > end) break;
            this.ranges.set(pos, new ObjectValueRange<T>(end + 1L, range.getEnd(), range.getValue()));
        }
    }

    public synchronized boolean contains(long index) {
        if (this.lastRange != null && this.lastRange.contains(index)) {
            return true;
        }
        int pos = this.getPositionOfRangeAtOrBefore(new ObjectValueRange<Object>(index, index, null));
        if (pos < 0) {
            return false;
        }
        this.lastRange = this.ranges.get(pos);
        return this.lastRange.contains(index);
    }

    public synchronized T getObject(long index) {
        if (this.lastRange != null && this.lastRange.contains(index)) {
            return this.lastRange.getValue();
        }
        int pos = this.getPositionOfRangeAtOrBefore(new ObjectValueRange<Object>(index, index, null));
        if (pos < 0) {
            return null;
        }
        this.lastRange = this.ranges.get(pos);
        if (this.lastRange.contains(index)) {
            return this.lastRange.getValue();
        }
        return null;
    }

    int getPositionOfRangeAtOrBefore(ObjectValueRange<T> valueRange) {
        int pos = Collections.binarySearch(this.ranges, valueRange);
        if (pos >= 0) {
            return pos;
        }
        if (pos == -1) {
            return -1;
        }
        pos = -pos - 2;
        return Math.min(pos, this.ranges.size());
    }

    int getPositionOfRangeBefore(ObjectValueRange<T> valueRange) {
        int pos = Collections.binarySearch(this.ranges, valueRange);
        if (pos >= 0) {
            return pos - 1;
        }
        if (pos == -1) {
            return -1;
        }
        pos = -pos - 2;
        return Math.min(pos, this.ranges.size());
    }

    private boolean valuesEqual(Object value, Object obj) {
        if (value == null) {
            return obj == null;
        }
        return value.equals(obj);
    }

    class SimpleIndexRangeIterator
    implements IndexRangeIterator {
        int pos = 0;

        SimpleIndexRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < ObjectRangeMap.this.ranges.size();
        }

        @Override
        public IndexRange next() {
            ObjectValueRange valueRange = ObjectRangeMap.this.ranges.get(this.pos++);
            return new IndexRange(valueRange.getStart(), valueRange.getEnd());
        }
    }

    class RestrictedIndexRangeIterator
    implements IndexRangeIterator {
        private int pos = 0;
        private long end;
        private IndexRange nextRange;

        RestrictedIndexRangeIterator(long start, long end) {
            ObjectValueRange range;
            this.end = end;
            this.pos = ObjectRangeMap.this.getPositionOfRangeAtOrBefore(new ObjectValueRange<Object>(start, end, null));
            if (this.pos >= 0 && (range = ObjectRangeMap.this.ranges.get(this.pos++)).contains(start)) {
                this.nextRange = new IndexRange(start, Math.min(range.getEnd(), end));
            }
            if (this.nextRange == null) {
                this.pos = Math.max(0, this.pos);
                this.getNextRange();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextRange != null;
        }

        @Override
        public IndexRange next() {
            IndexRange retRange = this.nextRange;
            if (this.nextRange != null) {
                this.getNextRange();
            }
            return retRange;
        }

        private void getNextRange() {
            ObjectValueRange range;
            this.nextRange = null;
            if (this.pos < ObjectRangeMap.this.ranges.size() && (range = ObjectRangeMap.this.ranges.get(this.pos++)).getStart() <= this.end) {
                this.nextRange = new IndexRange(range.getStart(), Math.min(range.getEnd(), this.end));
            }
        }
    }
}

