/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Prime;
import ghidra.util.datastruct.StringKeyIndexer;
import ghidra.util.exception.NoValueException;
import java.io.Serializable;
import java.util.Iterator;

public class StringIntHashtable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StringKeyIndexer indexer;
    private int[] values;
    private int capacity;

    public StringIntHashtable() {
        this(3);
    }

    public StringIntHashtable(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new StringKeyIndexer(capacity);
        this.values = new int[capacity];
    }

    public Iterator<String> getKeyIterator() {
        return this.indexer.getKeyIterator();
    }

    public void put(String key, int value) {
        int index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public int get(String key) throws NoValueException {
        int index = this.indexer.get(key);
        if (index < 0) {
            throw NoValueException.noValueException;
        }
        return this.values[index];
    }

    public boolean remove(String key) {
        return this.indexer.remove(key) >= 0;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(String key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public String[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        int[] oldValues = this.values;
        this.values = new int[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

