/*
 * Decompiled with CFR 0.152.
 */
package help.validator.links;

import help.validator.links.InvalidLink;
import help.validator.location.HelpModuleCollection;
import help.validator.model.TOCItem;
import java.nio.file.Path;

public class MissingTOCTargetIDInvalidLink
implements InvalidLink {
    private final TOCItem item;
    private final HelpModuleCollection help;

    public MissingTOCTargetIDInvalidLink(HelpModuleCollection help, TOCItem item) {
        this.help = help;
        this.item = item;
    }

    @Override
    public int identityHashCode() {
        return System.identityHashCode(this.item);
    }

    @Override
    public Path getSourceFile() {
        return this.item.getSourceFile();
    }

    @Override
    public int getLineNumber() {
        return this.item.getLineNumber();
    }

    @Override
    public int compareTo(InvalidLink other) {
        Path otherSourceFile;
        if (other == null) {
            return 1;
        }
        if (!(other instanceof MissingTOCTargetIDInvalidLink)) {
            return -1;
        }
        MissingTOCTargetIDInvalidLink otherLink = (MissingTOCTargetIDInvalidLink)other;
        Path sourceFile = this.item.getSourceFile();
        int result = sourceFile.compareTo(otherSourceFile = otherLink.item.getSourceFile());
        if (result != 0) {
            return result;
        }
        return this.item.getIDAttribute().compareTo(otherLink.item.getIDAttribute());
    }

    @Override
    public String toString() {
        return "Missing TOC target ID for definition (<tocdef>):\n\t" + String.valueOf(this.item);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.help == null ? 0 : this.help.hashCode());
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MissingTOCTargetIDInvalidLink other = (MissingTOCTargetIDInvalidLink)obj;
        if (this.help == null ? other.help != null : !this.help.equals(other.help)) {
            return false;
        }
        return !(this.item == null ? other.item != null : !this.item.equals(other.item));
    }
}

