/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GLabel;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.clear.ClearPlugin;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ClearFlowDialog
extends DialogComponentProvider {
    private ClearPlugin plugin;
    private JPanel panel;
    private JCheckBox symbolsCb;
    private JCheckBox dataCb;
    private JCheckBox repairCb;
    private ListingActionContext context;

    ClearFlowDialog(ClearPlugin plugin) {
        super("Clear Flow");
        this.plugin = plugin;
        this.create();
        this.addWorkPanel(this.panel);
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Clear_Flow_and_Repair"));
    }

    public void okCallback() {
        this.close();
        this.plugin.clearFlowAndRepair(this.context, this.symbolsCb.isSelected(), this.dataCb.isSelected(), this.repairCb.isSelected());
    }

    protected void cancelCallback() {
        this.close();
    }

    private void create() {
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ClearFlowDialog.this.okCallback();
                }
            }
        };
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(10, 10));
        this.panel.getAccessibleContext().setAccessibleName("Clear Flow Options");
        this.panel.add((Component)new GLabel("Clear Flow Options:"), "North");
        JPanel cbPanel = new JPanel();
        BoxLayout bl = new BoxLayout(cbPanel, 1);
        cbPanel.setLayout(bl);
        cbPanel.getAccessibleContext().setAccessibleName("Checkboxes");
        this.symbolsCb = new GCheckBox("Clear Symbols");
        this.symbolsCb.getAccessibleContext().setAccessibleName("Clear Symbols");
        this.dataCb = new GCheckBox("Clear Data");
        this.dataCb.getAccessibleContext().setAccessibleName("Clear Data");
        this.repairCb = new GCheckBox("Repair Flow");
        this.repairCb.getAccessibleContext().setAccessibleName("Repair Flow");
        this.symbolsCb.setSelected(false);
        this.symbolsCb.addKeyListener(listener);
        this.dataCb.setSelected(false);
        this.dataCb.addKeyListener(listener);
        this.repairCb.setSelected(true);
        this.repairCb.addKeyListener(listener);
        cbPanel.add(this.symbolsCb);
        cbPanel.add(this.dataCb);
        cbPanel.add(this.repairCb);
        JPanel p = new JPanel(new FlowLayout(1));
        p.add(cbPanel);
        this.panel.add((Component)p, "Center");
    }

    public void setProgramActionContext(ListingActionContext context) {
        this.context = context;
    }
}

