/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import aQute.bnd.osgi.Jar;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.GhidraBundle;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import ghidra.util.exception.AssertException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;

public class GhidraJarBundle
extends GhidraBundle {
    final String bundleLocation;

    public GhidraJarBundle(BundleHost bundleHost, ResourceFile file, boolean enabled, boolean systemBundle) {
        super(bundleHost, file, enabled, systemBundle);
        this.bundleLocation = file.toURI().toString();
    }

    @Override
    public boolean clean() {
        return false;
    }

    @Override
    public boolean build(PrintWriter writer) throws Exception {
        return false;
    }

    @Override
    public String getLocationIdentifier() {
        return this.bundleLocation;
    }

    protected ManifestParser createManifestParser() throws GhidraBundleException {
        ManifestParser manifestParser;
        Jar jar = new Jar(this.bundleFile.getFile(true));
        try {
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new GhidraBundleException(this.bundleLocation, "jar bundle with no manifest");
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            Map<String, Object> headerMap = mainAttributes.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
            manifestParser = new ManifestParser(null, null, null, headerMap);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BundleException e2) {
                throw new GhidraBundleException(this.bundleLocation, "parsing manifest", e2);
            }
            catch (GhidraBundleException e3) {
                throw e3;
            }
            catch (Exception e4) {
                throw new AssertException("Unexpected exception while parsing manifest", (Throwable)e4);
            }
        }
        jar.close();
        return manifestParser;
    }

    @Override
    public List<BundleRequirement> getAllRequirements() throws GhidraBundleException {
        ManifestParser manifestParser = this.createManifestParser();
        return manifestParser.getRequirements();
    }

    @Override
    public List<BundleCapability> getAllCapabilities() throws GhidraBundleException {
        ManifestParser manifestParser = this.createManifestParser();
        return manifestParser.getCapabilities();
    }
}

