/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.services.ProgramTreeService;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.RenameQuickFix;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.ProgramLocation;
import java.util.Map;

public class RenameProgramTreeGroupQuickFix
extends RenameQuickFix {
    private String path;
    private Group group;

    public RenameProgramTreeGroupQuickFix(Program program, Group group, String newName) {
        super(program, group.getName(), newName);
        this.group = group;
        this.path = this.computePath();
        this.checkForDuplicates();
    }

    private void checkForDuplicates() {
        ProgramModule[] parents = this.group.getParents();
        if (parents != null) {
            for (ProgramModule module : parents) {
                if (module.getIndex(this.replacement) < 0) continue;
                this.setStatus(QuickFixStatus.WARNING, "The name \"" + this.replacement + "\" already exists in module \"" + module.getName() + "\"");
            }
        }
    }

    @Override
    public void statusChanged(QuickFixStatus newStatus) {
        if (newStatus == QuickFixStatus.NONE) {
            this.checkForDuplicates();
        }
    }

    @Override
    public String getItemType() {
        if (this.group instanceof ProgramFragment) {
            return "Program Tree Fragment";
        }
        return "Program Tree Module";
    }

    private String computePath() {
        StringBuilder builder = new StringBuilder();
        this.computePath(this.group, builder);
        return builder.toString();
    }

    private void computePath(Group treeGroup, StringBuilder builder) {
        ProgramModule[] parents = treeGroup.getParents();
        if (parents.length > 0) {
            this.computePath((Group)parents[0], builder);
            builder.append("/");
        }
        builder.append(treeGroup.getName());
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    protected String doGetCurrent() {
        if (this.group.isDeleted()) {
            return null;
        }
        return this.group.getName();
    }

    @Override
    protected void execute() {
        try {
            this.group.setName(this.replacement);
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename Failed! " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        if (this.getAddress() != null) {
            return new ProgramLocation(this.program, this.getAddress());
        }
        return null;
    }

    @Override
    public Address getAddress() {
        return this.group.getMinAddress();
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        ProgramTreeService service = (ProgramTreeService)services.getService(ProgramTreeService.class);
        if (service == null) {
            return false;
        }
        service.setViewedTree(this.group.getTreeName());
        service.setGroupSelection(this.group.getGroupPath());
        return true;
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        return Map.of("Program Tree Path", this.path);
    }
}

