/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import java.math.BigInteger;

public abstract class AbstractIndirectVirtualBaseClassMsType
extends AbstractMsType
implements MsTypeField {
    protected RecordNumber directVirtualBaseClassRecordNumber;
    protected RecordNumber virtualBasePointerRecordNumber;
    protected ClassFieldMsAttributes attribute;
    protected BigInteger virtualBasePointerOffsetFromAddressPoint;
    protected BigInteger virtualBaseOffsetFromVBTable;

    public AbstractIndirectVirtualBaseClassMsType(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("<indirect ");
        builder.append(this.attribute);
        builder.append(": ");
        AbstractMsType type = this.pdb.getTypeRecord(this.directVirtualBaseClassRecordNumber);
        builder.append(type.getName());
        StringBuilder vbpBuilder = new StringBuilder();
        vbpBuilder.append("vbp");
        this.pdb.getTypeRecord(this.virtualBasePointerRecordNumber).emit(vbpBuilder, AbstractMsType.Bind.NONE);
        builder.append((CharSequence)vbpBuilder);
        builder.append("; offVbp=");
        builder.append(this.virtualBasePointerOffsetFromAddressPoint);
        builder.append("; offVbte=");
        builder.append(this.virtualBaseOffsetFromVBTable);
        builder.append("; >");
    }

    public BigInteger getBasePointerOffset() {
        return this.virtualBasePointerOffsetFromAddressPoint;
    }

    public BigInteger getBaseOffsetFromVbt() {
        return this.virtualBaseOffsetFromVBTable;
    }

    public ClassFieldMsAttributes getAttributes() {
        return this.attribute;
    }

    public RecordNumber getBaseClassRecordNumber() {
        return this.directVirtualBaseClassRecordNumber;
    }

    public RecordNumber getVirtualBasePointerRecordNumber() {
        return this.virtualBasePointerRecordNumber;
    }
}

