/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryCodedField;
import db.BinaryField;
import db.BooleanField;
import db.ByteField;
import db.DBRecord;
import db.Field;
import db.IllegalFieldAccessException;
import db.IntField;
import db.LongField;
import db.Schema;
import db.ShortField;
import db.StringField;
import ghidra.util.ObjectStorage;
import java.util.ArrayList;

public class ObjectStorageAdapterDB
implements ObjectStorage {
    private ArrayList<Field> fieldList = new ArrayList();
    private int col = 0;
    private boolean readOnly = false;

    public ObjectStorageAdapterDB() {
    }

    public ObjectStorageAdapterDB(DBRecord rec) {
        this.readOnly = true;
        Field[] fields = rec.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.fieldList.add(fields[i]);
        }
    }

    public void putInt(int value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new IntField(value));
    }

    public void putByte(byte value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new ByteField(value));
    }

    public void putShort(short value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new ShortField(value));
    }

    public void putLong(long value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new LongField(value));
    }

    public void putString(String value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new StringField(value));
    }

    public void putBoolean(boolean value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BooleanField(value));
    }

    public void putFloat(float value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public void putDouble(double value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public int getInt() {
        try {
            return this.fieldList.get(this.col++).getIntValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public byte getByte() {
        try {
            return this.fieldList.get(this.col++).getByteValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public short getShort() {
        try {
            return this.fieldList.get(this.col++).getShortValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public long getLong() {
        try {
            return this.fieldList.get(this.col++).getLongValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public boolean getBoolean() {
        try {
            return this.fieldList.get(this.col++).getBooleanValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public String getString() {
        try {
            return this.fieldList.get(this.col++).getString();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public float getFloat() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getFloatValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public double getDouble() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getDoubleValue();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public void putInts(int[] value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public void putBytes(byte[] value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public void putShorts(short[] value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public void putLongs(long[] value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public void putFloats(float[] value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public void putDoubles(double[] value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public void putStrings(String[] value) {
        if (this.readOnly) {
            throw new IllegalStateException();
        }
        this.fieldList.add(new BinaryCodedField(value));
    }

    public int[] getInts() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getIntArray();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public byte[] getBytes() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getByteArray();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public short[] getShorts() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getShortArray();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public long[] getLongs() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getLongArray();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public float[] getFloats() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getFloatArray();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public double[] getDoubles() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getDoubleArray();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public String[] getStrings() {
        try {
            BinaryCodedField codedField = new BinaryCodedField((BinaryField)this.fieldList.get(this.col++));
            return codedField.getStringArray();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalFieldAccessException();
        }
    }

    public Schema getSchema(int version) {
        Field[] fields = new Field[this.fieldList.size()];
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.fieldList.get(i).newField();
            fieldNames[i] = Integer.toString(i);
        }
        return new Schema(version, "key", fields, fieldNames);
    }

    public void save(DBRecord rec) {
        int cnt = this.fieldList.size();
        for (int i = 0; i < cnt; ++i) {
            rec.setField(i, this.fieldList.get(i));
        }
    }
}

