/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.j2k.DocCommentConverter;
import org.jetbrains.kotlin.j2k.ElementCreationStackTraceRequiredException;
import org.jetbrains.kotlin.j2k.ast.CommentsAndSpacesInheritance;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.PrototypeInfo;
import org.jetbrains.kotlin.j2k.ast.SpacesInheritance;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\u0018\u0000 92\u00020\u0001:\u0003789B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015J\u001a\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u000fH\u0002J\u001a\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\"\u001a\u00020\u001eH\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010 \u001a\u00020*H\u0086\u0004J&\u0010+\u001a\u00020,2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300H\u0002J,\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300H\u0002J \u00102\u001a\b\u0012\u0004\u0012\u00020\u000303*\b\u0012\u0004\u0012\u00020\u0003032\u0006\u0010 \u001a\u00020\u0003H\u0002J \u00104\u001a\b\u0012\u0004\u0012\u00020\u000303*\b\u0012\u0004\u0012\u00020\u0003032\u0006\u0010 \u001a\u00020\u0003H\u0002J \u00105\u001a\b\u0012\u0004\u0012\u00020\u000303*\b\u0012\u0004\u0012\u00020\u0003032\u0006\u0010 \u001a\u00020\u0003H\u0002J \u00106\u001a\b\u0012\u0004\u0012\u00020\u000303*\b\u0012\u0004\u0012\u00020\u0003032\u0006\u0010 \u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0011j\b\u0012\u0004\u0012\u00020\u0003`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "", "topElement", "Lcom/intellij/psi/PsiElement;", "docConverter", "Lorg/jetbrains/kotlin/idea/j2k/DocCommentConverter;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/idea/j2k/DocCommentConverter;)V", "commentPatternsToDrop", "", "Lkotlin/text/Regex;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "endOfLineCommentAtEnd", "", "commentsAndSpacesUsed", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "imports", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/LinkedHashSet;", "append", "text", "", "addImport", "", "fqName", "NON_COMMENT_INFO", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$CommentInfo;", "appendCommentOrWhiteSpace", "element", "postInsert", "commentInfo", "resultText", "getResultText", "()Ljava/lang/String;", "importsToAdd", "", "getImportsToAdd", "()Ljava/util/Set;", "Lorg/jetbrains/kotlin/j2k/ast/Element;", "collectPrefixElements", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "inheritance", "Lorg/jetbrains/kotlin/j2k/ast/CommentsAndSpacesInheritance;", "notInsideElements", "", "collectPostfixElements", "collectCommentsAndSpacesBefore", "", "collectCommentsAndSpacesAfter", "collectCommentsAndSpacesAtStart", "collectCommentsAndSpacesAtEnd", "CommentInfo", "Prefix", "Companion", "kotlin.j2k.k1.old"})
@SourceDebugExtension(value={"SMAP\nCodeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeBuilder.kt\norg/jetbrains/kotlin/j2k/CodeBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,370:1\n1761#2,3:371\n1869#2,2:381\n1869#2,2:383\n1#3:374\n607#4,6:375\n*S KotlinDebug\n*F\n+ 1 CodeBuilder.kt\norg/jetbrains/kotlin/j2k/CodeBuilder\n*L\n70#1:371,3\n152#1:381,2\n169#1:383,2\n92#1:375,6\n*E\n"})
public final class CodeBuilder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiElement topElement;
    @NotNull
    private DocCommentConverter docConverter;
    @NotNull
    private final List<Regex> commentPatternsToDrop;
    @NotNull
    private final StringBuilder builder;
    private boolean endOfLineCommentAtEnd;
    @NotNull
    private final HashSet<PsiElement> commentsAndSpacesUsed;
    @NotNull
    private final LinkedHashSet<FqName> imports;
    @NotNull
    private final CommentInfo NON_COMMENT_INFO;

    public CodeBuilder(@Nullable PsiElement topElement, @NotNull DocCommentConverter docConverter) {
        Intrinsics.checkNotNullParameter((Object)docConverter, (String)"docConverter");
        this.topElement = topElement;
        this.docConverter = docConverter;
        this.commentPatternsToDrop = CollectionsKt.listOf((Object)new Regex("^//[ ]*noinspection[ ]+[A-Za-z][A-Za-z0-9_]*([ ].*?)?$"));
        this.builder = new StringBuilder();
        this.commentsAndSpacesUsed = new HashSet();
        this.imports = new LinkedHashSet();
        this.NON_COMMENT_INFO = new CommentInfo(null, false);
    }

    @NotNull
    public final CodeBuilder append(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.append(text, this.NON_COMMENT_INFO);
    }

    public final void addImport(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        this.imports.add(fqName2);
    }

    private final void appendCommentOrWhiteSpace(PsiElement element, boolean postInsert) {
        block9: {
            block10: {
                boolean bl;
                block7: {
                    block8: {
                        if (!(element instanceof PsiDocComment)) break block8;
                        this.append(this.docConverter.convertDocComment((PsiDocComment)element));
                        break block9;
                    }
                    if (!(element instanceof PsiComment)) break block10;
                    Iterable $this$any$iv = this.commentPatternsToDrop;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Regex it = (Regex)element$iv;
                            boolean bl2 = false;
                            String string = ((PsiComment)element).getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            if (!it.matches((CharSequence)string)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) break block9;
            }
            String string = element.getText();
            Intrinsics.checkNotNull((Object)string);
            this.append(string, new CommentInfo(element, postInsert));
        }
    }

    static /* synthetic */ void appendCommentOrWhiteSpace$default(CodeBuilder codeBuilder, PsiElement psiElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        codeBuilder.appendCommentOrWhiteSpace(psiElement, bl);
    }

    private final CodeBuilder append(String text, CommentInfo commentInfo) {
        boolean bl;
        if (((CharSequence)text).length() == 0) {
            boolean bl2;
            boolean bl3 = bl2 = !commentInfo.getEndOfLineComment();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return this;
        }
        boolean bl4 = bl = StringsKt.indexOf$default((CharSequence)text, (char)'\r', (int)0, (boolean)false, (int)6, null) < 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CodeBuilder$append$22 = false;
            String $i$a$-assert-CodeBuilder$append$22 = "No '\\r' allowed";
            throw new AssertionError((Object)$i$a$-assert-CodeBuilder$append$22);
        }
        if (this.endOfLineCommentAtEnd) {
            if (text.charAt(0) != '\n') {
                this.builder.append('\n');
            }
            this.endOfLineCommentAtEnd = false;
        }
        if (commentInfo.isComment()) {
            if (!commentInfo.isPostInsert() && commentInfo.isFirstNonWhitespaceElementInLine()) {
                CharSequence charSequence;
                block11: {
                    CharSequence $this$takeLastWhile$iv = this.builder;
                    boolean $i$f$takeLastWhile = false;
                    for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                        char p0 = $this$takeLastWhile$iv.charAt(index$iv);
                        boolean bl5 = false;
                        if (CharsKt.isWhitespace((char)p0)) continue;
                        charSequence = $this$takeLastWhile$iv.subSequence(index$iv + 1, $this$takeLastWhile$iv.length());
                        break block11;
                    }
                    charSequence = $this$takeLastWhile$iv.subSequence(0, $this$takeLastWhile$iv.length());
                }
                if (!StringsKt.contains$default((CharSequence)charSequence, (char)'\n', (boolean)false, (int)2, null)) {
                    this.builder.append('\n');
                }
            }
            if (!commentInfo.isCommentAtFirstColumn()) {
                Character c = StringsKt.lastOrNull((CharSequence)this.builder);
                char c2 = '\n';
                if (c != null && c.charValue() == c2) {
                    this.builder.append(" ");
                }
            }
        }
        this.builder.append(text);
        this.endOfLineCommentAtEnd = commentInfo.getEndOfLineComment();
        return this;
    }

    static /* synthetic */ CodeBuilder append$default(CodeBuilder codeBuilder, String string, CommentInfo commentInfo, int n, Object object) {
        if ((n & 2) != 0) {
            commentInfo = codeBuilder.NON_COMMENT_INFO;
        }
        return codeBuilder.append(string, commentInfo);
    }

    @NotNull
    public final String getResultText() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final Set<FqName> getImportsToAdd() {
        return this.imports;
    }

    @NotNull
    public final CodeBuilder append(@NotNull Element element) {
        Object element$iv;
        int lineBreaksToAdd;
        int it;
        CommentsAndSpacesInheritance inheritance;
        Object prototype;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element.isEmpty()) {
                    return this;
                }
                if (element.getPrototypes() == null && this.topElement != null) {
                    if (element.getCreatedAt() == null) {
                        throw new ElementCreationStackTraceRequiredException();
                    }
                    String s = "Element " + element + " has no prototypes assigned.\nUse Element.assignPrototype() or Element.assignNoPrototype().\nElement created at:\n" + element.getCreatedAt();
                    throw new RuntimeException(s);
                }
                if (this.topElement == null || this.topElement instanceof PsiCompiledElement) break block14;
                List<PrototypeInfo> list2 = element.getPrototypes();
                Intrinsics.checkNotNull(list2);
                if (!list2.isEmpty()) break block15;
            }
            element.generateCode(this);
            element.postGenerateCode(this);
            return this;
        }
        HashSet<PsiElement> notInsideElements = new HashSet<PsiElement>();
        Prefix prefix2 = Prefix.Companion.getEmpty();
        List<PsiElement> postfix = CollectionsKt.emptyList();
        List<PrototypeInfo> list3 = element.getPrototypes();
        Intrinsics.checkNotNull(list3);
        for (PrototypeInfo prototypeInfo : list3) {
            boolean bl;
            prototype = prototypeInfo.component1();
            inheritance = prototypeInfo.component2();
            boolean bl2 = bl = !(prototype instanceof PsiComment);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = !(prototype instanceof PsiWhiteSpace);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (!PsiUtilsKt.isAncestor$default((PsiElement)this.topElement, (PsiElement)prototype, (boolean)false, (int)2, null)) continue;
            prefix2 = prefix2.plus(this.collectPrefixElements((PsiElement)prototype, inheritance, (Set<PsiElement>)notInsideElements));
            postfix = Companion.plus(postfix, this.collectPostfixElements((PsiElement)prototype, inheritance, (Set<PsiElement>)notInsideElements));
        }
        if (prefix2.getLineBreaksBefore() > 0 && (it = 1) <= (lineBreaksToAdd = prefix2.getLineBreaksBefore() - Companion.trailingLineBreakCount(this.builder))) {
            while (true) {
                this.append("\n");
                if (it == lineBreaksToAdd) break;
                ++it;
            }
        }
        Object $this$forEach$iv = prefix2.getElements();
        boolean $i$f$forEach2 = false;
        prototype = $this$forEach$iv.iterator();
        while (prototype.hasNext()) {
            element$iv = prototype.next();
            PsiElement it2 = (PsiElement)element$iv;
            boolean bl = false;
            CodeBuilder.appendCommentOrWhiteSpace$default(this, it2, false, 2, null);
        }
        element.generateCode(this);
        List<PrototypeInfo> list4 = element.getPrototypes();
        Intrinsics.checkNotNull(list4);
        for (PrototypeInfo $i$f$forEach2 : list4) {
            prototype = $i$f$forEach2.component1();
            inheritance = $i$f$forEach2.component2();
            if (!inheritance.getCommentsInside()) continue;
            prototype.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(notInsideElements, this){
                final /* synthetic */ HashSet<PsiElement> $notInsideElements;
                final /* synthetic */ CodeBuilder this$0;
                {
                    this.$notInsideElements = $notInsideElements;
                    this.this$0 = $receiver;
                }

                public void visitComment(PsiComment comment) {
                    Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                    if (!this.$notInsideElements.contains(comment) && CodeBuilder.access$getCommentsAndSpacesUsed$p(this.this$0).add(comment)) {
                        CodeBuilder.access$appendCommentOrWhiteSpace(this.this$0, (PsiElement)comment, true);
                    }
                }
            });
        }
        $this$forEach$iv = postfix;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            PsiElement it3 = (PsiElement)element$iv;
            boolean bl = false;
            CodeBuilder.appendCommentOrWhiteSpace$default(this, it3, false, 2, null);
        }
        element.postGenerateCode(this);
        return this;
    }

    private final Prefix collectPrefixElements(PsiElement element, CommentsAndSpacesInheritance inheritance, Set<PsiElement> notInsideElements) {
        List<PsiElement> before = this.collectCommentsAndSpacesBefore((List)new SmartList(), element);
        List<PsiElement> atStart = this.collectCommentsAndSpacesAtStart((List)new SmartList(), element);
        notInsideElements.addAll((Collection<PsiElement>)atStart);
        if (inheritance.getSpacesBefore() == SpacesInheritance.NONE && !inheritance.getCommentsBefore()) {
            return Prefix.Companion.getEmpty();
        }
        Object object = CollectionsKt.lastOrNull(before);
        PsiWhiteSpace firstSpace = object instanceof PsiWhiteSpace ? (PsiWhiteSpace)object : null;
        int lineBreaks = 0;
        if (firstSpace != null) {
            lineBreaks = Companion.lineBreakCount(firstSpace);
            switch (WhenMappings.$EnumSwitchMapping$0[inheritance.getSpacesBefore().ordinal()]) {
                case 1: {
                    lineBreaks = 0;
                    break;
                }
                case 2: {
                    this.commentsAndSpacesUsed.add((PsiElement)firstSpace);
                    break;
                }
                case 3: {
                    this.commentsAndSpacesUsed.add((PsiElement)firstSpace);
                    if (lineBreaks != 1) break;
                    lineBreaks = 0;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (!inheritance.getCommentsBefore()) {
            return new Prefix(CollectionsKt.emptyList(), lineBreaks);
        }
        if (firstSpace != null) {
            before.remove(CollectionsKt.getLastIndex(before));
        }
        List<PsiElement> elements = Companion.plus(CollectionsKt.asReversedMutable(before), atStart);
        this.commentsAndSpacesUsed.addAll((Collection<PsiElement>)elements);
        return new Prefix(elements, lineBreaks);
    }

    private final List<PsiElement> collectPostfixElements(PsiElement element, CommentsAndSpacesInheritance inheritance, Set<PsiElement> notInsideElements) {
        PsiElement last;
        List<PsiElement> atEnd = this.collectCommentsAndSpacesAtEnd((List)new SmartList(), element);
        notInsideElements.addAll((Collection<PsiElement>)atEnd);
        if (!inheritance.getCommentsAfter()) {
            return CollectionsKt.emptyList();
        }
        List<PsiElement> after = this.collectCommentsAndSpacesAfter((List)new SmartList(), element);
        if (!((Collection)after).isEmpty() && (last = (PsiElement)CollectionsKt.last(after)) instanceof PsiWhiteSpace) {
            after.remove(CollectionsKt.getLastIndex(after));
        }
        List<PsiElement> result2 = Companion.plus(CollectionsKt.asReversedMutable(atEnd), after);
        this.commentsAndSpacesUsed.addAll((Collection<PsiElement>)result2);
        return result2;
    }

    private final List<PsiElement> collectCommentsAndSpacesBefore(List<PsiElement> $this$collectCommentsAndSpacesBefore, PsiElement element) {
        if (Intrinsics.areEqual((Object)element, (Object)this.topElement)) {
            return $this$collectCommentsAndSpacesBefore;
        }
        PsiElement prev = element.getPrevSibling();
        if (prev != null) {
            if (Companion.isCommentOrSpace(prev)) {
                if (!this.commentsAndSpacesUsed.contains(prev)) {
                    $this$collectCommentsAndSpacesBefore.add(prev);
                    this.collectCommentsAndSpacesBefore($this$collectCommentsAndSpacesBefore, prev);
                }
            } else if (Companion.isEmptyElement(prev)) {
                this.collectCommentsAndSpacesBefore($this$collectCommentsAndSpacesBefore, prev);
            }
        } else {
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNull((Object)psiElement);
            this.collectCommentsAndSpacesBefore($this$collectCommentsAndSpacesBefore, psiElement);
        }
        return $this$collectCommentsAndSpacesBefore;
    }

    private final List<PsiElement> collectCommentsAndSpacesAfter(List<PsiElement> $this$collectCommentsAndSpacesAfter, PsiElement element) {
        if (Intrinsics.areEqual((Object)element, (Object)this.topElement)) {
            return $this$collectCommentsAndSpacesAfter;
        }
        PsiElement next2 = element.getNextSibling();
        if (next2 != null) {
            if (Companion.isCommentOrSpace(next2)) {
                if (next2 instanceof PsiWhiteSpace && Companion.hasLineBreaks((PsiWhiteSpace)next2)) {
                    return $this$collectCommentsAndSpacesAfter;
                }
                if (!this.commentsAndSpacesUsed.contains(next2)) {
                    $this$collectCommentsAndSpacesAfter.add(next2);
                    this.collectCommentsAndSpacesAfter($this$collectCommentsAndSpacesAfter, next2);
                }
            } else if (Companion.isEmptyElement(next2)) {
                this.collectCommentsAndSpacesAfter($this$collectCommentsAndSpacesAfter, next2);
            }
        } else {
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNull((Object)psiElement);
            this.collectCommentsAndSpacesAfter($this$collectCommentsAndSpacesAfter, psiElement);
        }
        return $this$collectCommentsAndSpacesAfter;
    }

    private final List<PsiElement> collectCommentsAndSpacesAtStart(List<PsiElement> $this$collectCommentsAndSpacesAtStart, PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Companion.isCommentOrSpace(child)) {
                if (this.commentsAndSpacesUsed.contains(child)) break;
                $this$collectCommentsAndSpacesAtStart.add(child);
                continue;
            }
            if (Companion.isEmptyElement(child)) continue;
            this.collectCommentsAndSpacesAtStart($this$collectCommentsAndSpacesAtStart, child);
            break;
        }
        return $this$collectCommentsAndSpacesAtStart;
    }

    private final List<PsiElement> collectCommentsAndSpacesAtEnd(List<PsiElement> $this$collectCommentsAndSpacesAtEnd, PsiElement element) {
        for (PsiElement child = element.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (Companion.isCommentOrSpace(child)) {
                if (this.commentsAndSpacesUsed.contains(child)) break;
                $this$collectCommentsAndSpacesAtEnd.add(child);
                continue;
            }
            if (Companion.isEmptyElement(child)) continue;
            this.collectCommentsAndSpacesAtEnd($this$collectCommentsAndSpacesAtEnd, child);
            break;
        }
        return $this$collectCommentsAndSpacesAtEnd;
    }

    public static final /* synthetic */ HashSet access$getCommentsAndSpacesUsed$p(CodeBuilder $this) {
        return $this.commentsAndSpacesUsed;
    }

    public static final /* synthetic */ void access$appendCommentOrWhiteSpace(CodeBuilder $this, PsiElement element, boolean postInsert) {
        $this.appendCommentOrWhiteSpace(element, postInsert);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$CommentInfo;", "", "element", "Lcom/intellij/psi/PsiElement;", "isPostInsert", "", "<init>", "(Lcom/intellij/psi/PsiElement;Z)V", "()Z", "isComment", "endOfLineComment", "getEndOfLineComment", "isCommentAtFirstColumn", "isFirstNonWhitespaceElementInLine", "kotlin.j2k.k1.old"})
    private static final class CommentInfo {
        private final boolean isPostInsert;
        private final boolean isComment;
        private final boolean endOfLineComment;
        private final boolean isCommentAtFirstColumn;
        private final boolean isFirstNonWhitespaceElementInLine;

        public CommentInfo(@Nullable PsiElement element, boolean isPostInsert) {
            this.isPostInsert = isPostInsert;
            this.isComment = element instanceof PsiComment;
            this.endOfLineComment = element != null ? Companion.isEndOfLineComment(element) : false;
            this.isCommentAtFirstColumn = element != null ? Companion.isCommentAtFirstColumn(element) : false;
            this.isFirstNonWhitespaceElementInLine = element != null ? Companion.isFirstNonWhitespaceElementInLine(element) : false;
        }

        public final boolean isPostInsert() {
            return this.isPostInsert;
        }

        public final boolean isComment() {
            return this.isComment;
        }

        public final boolean getEndOfLineComment() {
            return this.endOfLineComment;
        }

        public final boolean isCommentAtFirstColumn() {
            return this.isCommentAtFirstColumn;
        }

        public final boolean isFirstNonWhitespaceElementInLine() {
            return this.isFirstNonWhitespaceElementInLine;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005H\u0086\u0002J\n\u0010\b\u001a\u00020\t*\u00020\nJ\n\u0010\u000b\u001a\u00020\t*\u00020\nJ\n\u0010\f\u001a\u00020\t*\u00020\nJ\n\u0010\r\u001a\u00020\t*\u00020\nJ\n\u0010\u000e\u001a\u00020\t*\u00020\nJ\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011J\n\u0010\u0012\u001a\u00020\t*\u00020\u0011J\n\u0010\u0013\u001a\u00020\u0010*\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Companion;", "", "<init>", "()V", "plus", "", "T", "other", "isCommentOrSpace", "", "Lcom/intellij/psi/PsiElement;", "isEndOfLineComment", "isEmptyElement", "isCommentAtFirstColumn", "isFirstNonWhitespaceElementInLine", "lineBreakCount", "", "Lcom/intellij/psi/PsiWhiteSpace;", "hasLineBreaks", "trailingLineBreakCount", "", "kotlin.j2k.k1.old"})
    @SourceDebugExtension(value={"SMAP\nCodeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeBuilder.kt\norg/jetbrains/kotlin/j2k/CodeBuilder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final <T> List<T> plus(@NotNull List<? extends T> $this$plus, @NotNull List<? extends T> other) {
            List list2;
            Intrinsics.checkNotNullParameter($this$plus, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            if ($this$plus.isEmpty()) {
                list2 = other;
            } else if (other.isEmpty()) {
                list2 = $this$plus;
            } else {
                void var3_3;
                ArrayList result2 = new ArrayList($this$plus.size() + other.size());
                result2.addAll($this$plus);
                result2.addAll(other);
                list2 = (List)var3_3;
            }
            return list2;
        }

        public final boolean isCommentOrSpace(@NotNull PsiElement $this$isCommentOrSpace) {
            Intrinsics.checkNotNullParameter((Object)$this$isCommentOrSpace, (String)"<this>");
            return $this$isCommentOrSpace instanceof PsiComment || $this$isCommentOrSpace instanceof PsiWhiteSpace;
        }

        public final boolean isEndOfLineComment(@NotNull PsiElement $this$isEndOfLineComment) {
            Intrinsics.checkNotNullParameter((Object)$this$isEndOfLineComment, (String)"<this>");
            return $this$isEndOfLineComment instanceof PsiComment && Intrinsics.areEqual((Object)((PsiComment)$this$isEndOfLineComment).getTokenType(), (Object)JavaTokenType.END_OF_LINE_COMMENT);
        }

        public final boolean isEmptyElement(@NotNull PsiElement $this$isEmptyElement) {
            Intrinsics.checkNotNullParameter((Object)$this$isEmptyElement, (String)"<this>");
            return $this$isEmptyElement.getFirstChild() == null && $this$isEmptyElement.getTextLength() == 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCommentAtFirstColumn(@NotNull PsiElement $this$isCommentAtFirstColumn) {
            Intrinsics.checkNotNullParameter((Object)$this$isCommentAtFirstColumn, (String)"<this>");
            if (!($this$isCommentAtFirstColumn instanceof PsiComment)) return false;
            PsiElement psiElement = ((PsiComment)$this$isCommentAtFirstColumn).getPrevSibling();
            if (psiElement == null) return false;
            PsiElement it = psiElement;
            boolean bl = false;
            if (!(it instanceof PsiWhiteSpace)) return false;
            String string = ((PsiWhiteSpace)it).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"\\n", (boolean)false, (int)2, null)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFirstNonWhitespaceElementInLine(@NotNull PsiElement $this$isFirstNonWhitespaceElementInLine) {
            Intrinsics.checkNotNullParameter((Object)$this$isFirstNonWhitespaceElementInLine, (String)"<this>");
            if (!($this$isFirstNonWhitespaceElementInLine instanceof PsiComment)) return false;
            PsiElement psiElement = ((PsiComment)$this$isFirstNonWhitespaceElementInLine).getPrevSibling();
            if (psiElement == null) return false;
            PsiElement it = psiElement;
            boolean bl = false;
            if (!(it instanceof PsiWhiteSpace)) return false;
            String string = ((PsiWhiteSpace)it).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) return false;
            return true;
        }

        public final int lineBreakCount(@NotNull PsiWhiteSpace $this$lineBreakCount) {
            Intrinsics.checkNotNullParameter((Object)$this$lineBreakCount, (String)"<this>");
            return StringUtil.getLineBreakCount((CharSequence)$this$lineBreakCount.getText());
        }

        public final boolean hasLineBreaks(@NotNull PsiWhiteSpace $this$hasLineBreaks) {
            Intrinsics.checkNotNullParameter((Object)$this$hasLineBreaks, (String)"<this>");
            return StringUtil.containsLineBreak((CharSequence)$this$hasLineBreaks.getText());
        }

        public final int trailingLineBreakCount(@NotNull CharSequence $this$trailingLineBreakCount) {
            int i2;
            Intrinsics.checkNotNullParameter((Object)$this$trailingLineBreakCount, (String)"<this>");
            for (i2 = $this$trailingLineBreakCount.length() - 1; i2 >= 0 && $this$trailingLineBreakCount.charAt(i2) == '\n'; --i2) {
            }
            return $this$trailingLineBreakCount.length() - i2 - 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "lineBreaksBefore", "", "<init>", "(Ljava/util/List;I)V", "getElements", "()Ljava/util/List;", "getLineBreaksBefore", "()I", "plus", "other", "isEmpty", "", "component1", "component2", "copy", "equals", "hashCode", "toString", "", "Companion", "kotlin.j2k.k1.old"})
    private static final class Prefix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<PsiElement> elements;
        private final int lineBreaksBefore;
        @NotNull
        private static final Prefix Empty = new Prefix(CollectionsKt.emptyList(), 0);

        public Prefix(@NotNull List<? extends PsiElement> elements, int lineBreaksBefore) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.elements = elements;
            this.lineBreaksBefore = lineBreaksBefore;
        }

        @NotNull
        public final List<PsiElement> getElements() {
            return this.elements;
        }

        public final int getLineBreaksBefore() {
            return this.lineBreaksBefore;
        }

        @NotNull
        public final Prefix plus(@NotNull Prefix other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.isEmpty() ? other : (other.isEmpty() ? this : new Prefix(Companion.plus(this.elements, other.elements), Math.max(this.lineBreaksBefore, other.lineBreaksBefore)));
        }

        private final boolean isEmpty() {
            return this.elements.isEmpty() && this.lineBreaksBefore == 0;
        }

        @NotNull
        public final List<PsiElement> component1() {
            return this.elements;
        }

        public final int component2() {
            return this.lineBreaksBefore;
        }

        @NotNull
        public final Prefix copy(@NotNull List<? extends PsiElement> elements, int lineBreaksBefore) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return new Prefix(elements, lineBreaksBefore);
        }

        public static /* synthetic */ Prefix copy$default(Prefix prefix2, List list2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list2 = prefix2.elements;
            }
            if ((n2 & 2) != 0) {
                n = prefix2.lineBreaksBefore;
            }
            return prefix2.copy(list2, n);
        }

        @NotNull
        public String toString() {
            return "Prefix(elements=" + this.elements + ", lineBreaksBefore=" + this.lineBreaksBefore + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.elements).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.lineBreaksBefore);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Prefix)) {
                return false;
            }
            Prefix prefix2 = (Prefix)other;
            if (!Intrinsics.areEqual(this.elements, prefix2.elements)) {
                return false;
            }
            return this.lineBreaksBefore == prefix2.lineBreaksBefore;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix$Companion;", "", "<init>", "()V", "Empty", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "getEmpty", "()Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "kotlin.j2k.k1.old"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Prefix getEmpty() {
                return Empty;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpacesInheritance.values().length];
            try {
                nArray[SpacesInheritance.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpacesInheritance.LINE_BREAKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpacesInheritance.BLANK_LINES_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

