/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.AbstractTypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedTypeAliasDescriptor
extends AbstractTypeAliasDescriptor
implements DeserializedMemberDescriptor {
    @NotNull
    private final ProtoBuf.TypeAlias proto;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @NotNull
    private final VersionRequirementTable versionRequirementTable;
    @Nullable
    private final DeserializedContainerSource containerSource;
    private SimpleType underlyingType;
    private SimpleType expandedType;
    private List<? extends TypeParameterDescriptor> typeConstructorParameters;
    private SimpleType defaultTypeImpl;

    public DeserializedTypeAliasDescriptor(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations, @NotNull Name name, @NotNull DescriptorVisibility visibility, @NotNull ProtoBuf.TypeAlias proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @NotNull VersionRequirementTable versionRequirementTable, @Nullable DeserializedContainerSource containerSource) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)containingDeclaration, (String)"containingDeclaration");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
        Intrinsics.checkNotNullParameter((Object)versionRequirementTable, (String)"versionRequirementTable");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
        super(storageManager, containingDeclaration, annotations, name, sourceElement, visibility);
        this.proto = proto;
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        this.versionRequirementTable = versionRequirementTable;
        this.containerSource = containerSource;
    }

    @Override
    @NotNull
    public ProtoBuf.TypeAlias getProto() {
        return this.proto;
    }

    @Override
    @NotNull
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @Override
    @NotNull
    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    @NotNull
    public VersionRequirementTable getVersionRequirementTable() {
        return this.versionRequirementTable;
    }

    @Override
    @Nullable
    public DeserializedContainerSource getContainerSource() {
        return this.containerSource;
    }

    @Override
    @NotNull
    public SimpleType getUnderlyingType() {
        SimpleType simpleType = this.underlyingType;
        if (simpleType != null) {
            return simpleType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"underlyingType");
        return null;
    }

    @Override
    @NotNull
    public SimpleType getExpandedType() {
        SimpleType simpleType = this.expandedType;
        if (simpleType != null) {
            return simpleType;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"expandedType");
        return null;
    }

    public final void initialize(@NotNull List<? extends TypeParameterDescriptor> declaredTypeParameters, @NotNull SimpleType underlyingType, @NotNull SimpleType expandedType) {
        Intrinsics.checkNotNullParameter(declaredTypeParameters, (String)"declaredTypeParameters");
        Intrinsics.checkNotNullParameter((Object)underlyingType, (String)"underlyingType");
        Intrinsics.checkNotNullParameter((Object)expandedType, (String)"expandedType");
        this.initialize(declaredTypeParameters);
        this.underlyingType = underlyingType;
        this.expandedType = expandedType;
        this.typeConstructorParameters = TypeParameterUtilsKt.computeConstructorTypeParameters(this);
        this.defaultTypeImpl = this.computeDefaultType();
    }

    @Override
    @Nullable
    public ClassDescriptor getClassDescriptor() {
        ClassifierDescriptor classifierDescriptor;
        return KotlinTypeKt.isError(this.getExpandedType()) ? null : ((classifierDescriptor = this.getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null);
    }

    @Override
    @NotNull
    public SimpleType getDefaultType() {
        SimpleType simpleType = this.defaultTypeImpl;
        if (simpleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"defaultTypeImpl");
            simpleType = null;
        }
        return simpleType;
    }

    @Override
    @NotNull
    public TypeAliasDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        if (substitutor.isEmpty()) {
            return this;
        }
        StorageManager storageManager = this.getStorageManager();
        DeclarationDescriptor declarationDescriptor = this.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        Annotations annotations = this.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotations, (String)"<get-annotations>(...)");
        Name name = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        DeserializedTypeAliasDescriptor substituted = new DeserializedTypeAliasDescriptor(storageManager, declarationDescriptor, annotations, name, this.getVisibility(), this.getProto(), this.getNameResolver(), this.getTypeTable(), this.getVersionRequirementTable(), this.getContainerSource());
        List<TypeParameterDescriptor> list = this.getDeclaredTypeParameters();
        KotlinType kotlinType = substitutor.safeSubstitute(this.getUnderlyingType(), Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"safeSubstitute(...)");
        SimpleType simpleType = TypeSubstitutionKt.asSimpleType(kotlinType);
        KotlinType kotlinType2 = substitutor.safeSubstitute(this.getExpandedType(), Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"safeSubstitute(...)");
        substituted.initialize(list, simpleType, TypeSubstitutionKt.asSimpleType(kotlinType2));
        return substituted;
    }

    @Override
    @NotNull
    protected List<TypeParameterDescriptor> getTypeConstructorTypeParameters() {
        List<TypeParameterDescriptor> list = this.typeConstructorParameters;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeConstructorParameters");
            list = null;
        }
        return list;
    }
}

