/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.PatternFuture;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.impl.SchemaReaderImpl;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.ParseReceiver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.rng.RngProperty;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SchemaReceiverImpl
implements SchemaReceiver {
    private final ParseReceiver parser;
    private final PropertyMap properties;

    public SchemaReceiverImpl(ParseReceiver parseReceiver, PropertyMap propertyMap) {
        this.parser = parseReceiver;
        this.properties = propertyMap;
    }

    public SchemaFuture installHandlers(XMLReader xMLReader) throws SAXException {
        final SchemaPatternBuilder schemaPatternBuilder = new SchemaPatternBuilder();
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(this.properties);
        DatatypeLibraryFactory datatypeLibraryFactory = RngProperty.DATATYPE_LIBRARY_FACTORY.get(this.properties);
        if (datatypeLibraryFactory == null) {
            datatypeLibraryFactory = new DatatypeLibraryLoader();
        }
        final PatternFuture patternFuture = SchemaBuilderImpl.installHandlers(this.parser, xMLReader, errorHandler, datatypeLibraryFactory, schemaPatternBuilder);
        return new SchemaFuture(){

            public Schema getSchema() throws IncorrectSchemaException, SAXException, IOException {
                return SchemaReaderImpl.wrapPattern(patternFuture.getPattern(SchemaReceiverImpl.this.properties.contains(NrlProperty.ATTRIBUTES_SCHEMA)), schemaPatternBuilder, SchemaReceiverImpl.this.properties);
            }

            public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
                if (runtimeException instanceof BuildException) {
                    return SchemaBuilderImpl.unwrapBuildException((BuildException)runtimeException);
                }
                return runtimeException;
            }
        };
    }
}

