/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;

public class CheckTransactionRpcCommand
implements CacheRpcCommand {
    public static final int COMMAND_ID = 83;
    private static final ResponseCollectorImpl INSTANCE = new ResponseCollectorImpl();
    private final ByteString cacheName;
    private Collection<GlobalTransaction> gtxToCheck;

    public CheckTransactionRpcCommand() {
        this(null);
    }

    public CheckTransactionRpcCommand(ByteString cacheName, Collection<GlobalTransaction> gtxToCheck) {
        this.cacheName = cacheName;
        this.gtxToCheck = gtxToCheck;
    }

    public CheckTransactionRpcCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public static ResponseCollector<Collection<GlobalTransaction>> responseCollector() {
        return INSTANCE;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) {
        TransactionTable txTable = componentRegistry.getTransactionTable();
        this.gtxToCheck.removeIf(txTable::containsLocalTx);
        return CompletableFuture.completedFuture(this.gtxToCheck);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.gtxToCheck, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.gtxToCheck = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    @Override
    public byte getCommandId() {
        return 83;
    }

    public String toString() {
        return "CheckTransactionRpcCommand{cacheName=" + String.valueOf(this.cacheName) + ", gtxToCheck=" + String.valueOf(this.gtxToCheck) + "}";
    }

    private static class ResponseCollectorImpl
    extends ValidSingleResponseCollector<Collection<GlobalTransaction>> {
        private ResponseCollectorImpl() {
        }

        @Override
        protected Collection<GlobalTransaction> withValidResponse(Address sender, ValidResponse response) {
            if (response instanceof SuccessfulResponse) {
                return (Collection)response.getResponseValue();
            }
            return Collections.emptyList();
        }

        @Override
        protected Collection<GlobalTransaction> targetNotFound(Address sender) {
            return Collections.emptyList();
        }

        @Override
        protected Collection<GlobalTransaction> withException(Address sender, Exception exception) {
            return Collections.emptyList();
        }
    }
}

