/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RemovableCloseableIterator;

class RemoteCacheKeySet<K>
extends AbstractSet<K>
implements CloseableIteratorSet<K> {
    private final InternalRemoteCache<K, ?> remoteCache;
    private final IntSet segments;

    RemoteCacheKeySet(InternalRemoteCache<K, ?> remoteCache, IntSet segments) {
        this.remoteCache = remoteCache;
        this.segments = segments;
    }

    @Override
    public CloseableIterator<K> iterator() {
        CloseableIterator<K> keyIterator = this.remoteCache.keyIterator(this.segments);
        return new RemovableCloseableIterator(keyIterator, this::remove);
    }

    @Override
    public CloseableSpliterator<K> spliterator() {
        return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
    }

    @Override
    public Stream<K> stream() {
        return Closeables.stream(this.spliterator(), (boolean)false);
    }

    @Override
    public Stream<K> parallelStream() {
        return Closeables.stream(this.spliterator(), (boolean)true);
    }

    @Override
    public int size() {
        return this.remoteCache.size();
    }

    @Override
    public void clear() {
        this.remoteCache.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.remoteCache.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.remoteCache.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removedSomething = false;
        for (Object key : c) {
            removedSomething |= this.remove(key);
        }
        return removedSomething;
    }
}

