/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.oracle.runtime;

import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.exceptionsorter.OracleExceptionSorter;
import io.quarkus.agroal.runtime.AgroalConnectionConfigurer;
import io.quarkus.agroal.runtime.JdbcDriver;
import java.util.Map;

@JdbcDriver(value="oracle")
public class OracleAgroalConnectionConfigurer
implements AgroalConnectionConfigurer {
    public void disableSslSupport(String databaseKind, AgroalDataSourceConfigurationSupplier dataSourceConfiguration, Map<String, String> additionalProperties) {
        String property = additionalProperties.get("oracle.net.authentication_services");
        if (property != null && "SSL".equalsIgnoreCase(property)) {
            log.warnv("SSL support has been disabled, but one of the Oracle JDBC connections has been configured to use SSL. This will likely fail", new Object[0]);
        }
    }

    public void setExceptionSorter(String databaseKind, AgroalDataSourceConfigurationSupplier dataSourceConfiguration) {
        dataSourceConfiguration.connectionPoolConfiguration().exceptionSorter((AgroalConnectionPoolConfiguration.ExceptionSorter)new OracleExceptionSorter());
    }
}

