/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedSoftDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedUpdateHandler;
import org.hibernate.query.sqm.mutation.spi.MultiTableHandler;
import org.hibernate.query.sqm.mutation.spi.MultiTableHandlerBuildResult;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class PersistentTableMutationStrategy
extends PersistentTableStrategy
implements SqmMultiTableMutationStrategy {
    public PersistentTableMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        this(rootEntityDescriptor, runtimeModelCreationContext.getDialect().getPersistentTemporaryTableStrategy(), runtimeModelCreationContext);
    }

    private PersistentTableMutationStrategy(EntityMappingType rootEntityDescriptor, TemporaryTableStrategy temporaryTableStrategy, RuntimeModelCreationContext runtimeModelCreationContext) {
        this(TemporaryTable.createIdTable(runtimeModelCreationContext.getBootModel().getEntityBinding(rootEntityDescriptor.getEntityName()), basename -> temporaryTableStrategy.adjustTemporaryTableName("HT_" + basename), TemporaryTableKind.PERSISTENT, runtimeModelCreationContext.getDialect(), runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public PersistentTableMutationStrategy(TemporaryTable idTable, SessionFactoryImplementor sessionFactory) {
        super(idTable, sessionFactory);
    }

    @Override
    public MultiTableHandlerBuildResult buildHandler(SqmDeleteOrUpdateStatement<?> sqmStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        MultiTableHandler multiTableHandler;
        MutableObject<JdbcParameterBindings> firstJdbcParameterBindings = new MutableObject<JdbcParameterBindings>();
        if (sqmStatement instanceof SqmDeleteStatement) {
            SqmDeleteStatement sqmDelete = (SqmDeleteStatement)sqmStatement;
            multiTableHandler = this.buildHandler(sqmDelete, domainParameterXref, context, firstJdbcParameterBindings);
        } else {
            multiTableHandler = this.buildHandler((SqmUpdateStatement)sqmStatement, domainParameterXref, context, firstJdbcParameterBindings);
        }
        MultiTableHandler multiTableHandler2 = multiTableHandler;
        return new MultiTableHandlerBuildResult(multiTableHandler2, firstJdbcParameterBindings.get());
    }

    public MultiTableHandler buildHandler(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        return new TableBasedUpdateHandler(sqmUpdate, domainParameterXref, this.getTemporaryTable(), this.getTemporaryTableStrategy(), false, session -> session.getSessionIdentifier().toString(), context, firstJdbcParameterBindingsConsumer);
    }

    public MultiTableHandler buildHandler(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        EntityPersister rootDescriptor = context.getSession().getFactory().getMappingMetamodel().getEntityDescriptor(((SqmRoot)sqmDelete.getRoot()).getEntityName());
        if (rootDescriptor.getSoftDeleteMapping() != null) {
            return new TableBasedSoftDeleteHandler(sqmDelete, domainParameterXref, this.getTemporaryTable(), this.getTemporaryTableStrategy(), false, session -> session.getSessionIdentifier().toString(), context, firstJdbcParameterBindingsConsumer);
        }
        return new TableBasedDeleteHandler(sqmDelete, domainParameterXref, this.getTemporaryTable(), this.getTemporaryTableStrategy(), false, session -> session.getSessionIdentifier().toString(), context, firstJdbcParameterBindingsConsumer);
    }
}

