/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderFactory;

public class CryptoUtils {
    public static List<String> getSupportedAsymmetricSignatureAlgorithms(KeycloakSession session) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(SignatureProvider.class).map(ProviderFactory::getId).map(algorithm -> new AbstractMap.SimpleEntry<String, SignatureProvider>((String)algorithm, (SignatureProvider)session.getProvider(SignatureProvider.class, algorithm))).filter(entry -> entry.getValue() != null).filter(entry -> ((SignatureProvider)entry.getValue()).isAsymmetricAlgorithm()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static List<String> getSupportedAsymmetricEncryptionAlgorithms(KeycloakSession session) {
        return session.keys().getKeysStream(session.getContext().getRealm()).filter(key -> KeyUse.ENC.equals((Object)key.getUse())).filter(key -> {
            Key k = key.getPublicKey();
            return k instanceof PublicKey || key.getPrivateKey() instanceof PrivateKey;
        }).map(KeyWrapper::getAlgorithm).filter(algorithm -> algorithm != null && !algorithm.isEmpty()).distinct().toList();
    }
}

