/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.FrameConsumer;
import com.github.kokorin.jaffree.ffmpeg.ImageFormat;
import com.github.kokorin.jaffree.ffmpeg.ImageFormats;
import com.github.kokorin.jaffree.ffmpeg.NutFrameReader;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.TcpOutput;
import com.github.kokorin.jaffree.net.TcpNegotiator;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class FrameOutput
extends TcpOutput<FrameOutput>
implements Output {
    protected FrameOutput(FrameReader frameReader, String format, String videoCodec, String pixelFormat, String audioCodec) {
        super(new FrameOutputNegotiator(frameReader));
        super.setFormat(format);
        super.setCodec(StreamType.VIDEO.code(), videoCodec);
        super.setPixelFormat(null, pixelFormat);
        super.setCodec(StreamType.AUDIO.code(), audioCodec);
    }

    @Override
    public final FrameOutput setFormat(String format) {
        throw new JaffreeException("Format can't be changed");
    }

    @Override
    public final FrameOutput setCodec(String streamSpecifier, String codec) {
        throw new JaffreeException("Codec can't be changed");
    }

    @Override
    public final FrameOutput setCodec(StreamType streamType, String codec) {
        throw new JaffreeException("Codec can't be changed");
    }

    @Override
    public final FrameOutput copyAllCodecs() {
        throw new JaffreeException("Codec can't be changed");
    }

    @Override
    public final FrameOutput copyCodec(String streamSpecifier) {
        throw new JaffreeException("Codec can't be changed");
    }

    @Override
    public final FrameOutput copyCodec(StreamType streamType) {
        throw new JaffreeException("Codec can't be changed");
    }

    @Override
    public final FrameOutput setPixelFormat(String streamSpecifier, String pixelFormat) {
        throw new JaffreeException("Pixel Format can't be changed");
    }

    @Override
    public FrameOutput disableStream(StreamType streamType) {
        super.disableStream(streamType);
        switch (streamType) {
            case VIDEO: {
                super.setCodec(StreamType.VIDEO.code(), null);
                super.setPixelFormat(null, null);
                break;
            }
            case AUDIO: {
                super.setCodec(StreamType.AUDIO.code(), null);
                break;
            }
        }
        return this;
    }

    public static FrameOutput withConsumer(FrameConsumer consumer) {
        return FrameOutput.withConsumer(consumer, ImageFormats.BGR24);
    }

    public static FrameOutput withConsumerAlpha(FrameConsumer consumer) {
        return FrameOutput.withConsumer(consumer, ImageFormats.ABGR);
    }

    protected static FrameOutput withConsumer(FrameConsumer consumer, ImageFormat imageFormat) {
        return new FrameOutput(new NutFrameReader(consumer, imageFormat), "nut", "rawvideo", imageFormat.getPixelFormat(), "pcm_s32be");
    }

    protected static class FrameOutputNegotiator
    implements TcpNegotiator {
        private final FrameReader frameReader;

        public FrameOutputNegotiator(FrameReader frameReader) {
            this.frameReader = frameReader;
        }

        @Override
        public synchronized void negotiate(Socket socket) throws IOException {
            try (InputStream inputStream = socket.getInputStream();){
                this.frameReader.read(inputStream);
            }
        }
    }

    protected static interface FrameReader {
        public void read(InputStream var1) throws IOException;
    }
}

