/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.keystroke;

import java.awt.im.InputContext;
import java.util.Locale;
import java.util.logging.Logger;

class KeyStrokeLocale {
    static final String ASSERTJ_SWING_KEYBOARD_LOCALE = "assertj.swing.keyboard.locale";
    private static Logger LOGGER = Logger.getLogger(KeyStrokeLocale.class.getName());
    private static Locale locale;

    static void reloadFromSystemSettings() {
        LOGGER.finer("reload locale from settings");
        String propertyLocale = System.getProperty(ASSERTJ_SWING_KEYBOARD_LOCALE);
        LOGGER.finer("system property >assertj.swing.keyboard.locale<: " + propertyLocale);
        if (propertyLocale != null) {
            locale = Locale.forLanguageTag(propertyLocale);
            LOGGER.finer("using locale from system property: " + locale);
        }
        if (locale == null) {
            locale = InputContext.getInstance().getLocale();
            LOGGER.finer("using locale from input context: " + locale);
        }
        if (locale == null) {
            locale = Locale.getDefault();
            LOGGER.finer("using default locale: " + locale);
        }
    }

    static Locale get() {
        return locale;
    }

    private KeyStrokeLocale() {
    }

    static {
        KeyStrokeLocale.reloadFromSystemSettings();
    }
}

