/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.ChangeSetSelectionKt;
import com.intellij.platform.lvcs.impl.DirectoryDiffMode;
import com.intellij.platform.lvcs.impl.LocalHistoryActivityDataKt;
import com.intellij.platform.lvcs.impl.RevisionId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a,\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0000\u001a@\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nH\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a:\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\nH\u0000\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001d\u0010\u001c\u001a\u00070\b\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001eH\u0000\u00a8\u0006\u001f"}, d2={"findEntry", "Lcom/intellij/history/core/tree/Entry;", "Lcom/intellij/history/core/LocalHistoryFacade;", "rootEntry", "Lcom/intellij/history/core/tree/RootEntry;", "revisionId", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "entryPath", "", "before", "", "getSingleFileDiff", "Lcom/intellij/history/core/revisions/Difference;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "isOldContentUsed", "getDiff", "", "entryPaths", "", "diffMode", "Lcom/intellij/platform/lvcs/impl/DirectoryDiffMode;", "nextRevision", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "getEntryPaths", "getEntryPath", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/platform/lvcs/impl/ActivityScope$File;", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nDiffUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffUtils.kt\ncom/intellij/platform/lvcs/impl/diff/DiffUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1374#2:82\n1460#2,5:83\n1563#2:89\n1634#2,3:90\n1#3:88\n*S KotlinDebug\n*F\n+ 1 DiffUtils.kt\ncom/intellij/platform/lvcs/impl/diff/DiffUtilsKt\n*L\n44#1:82\n44#1:83,5\n76#1:89\n76#1:90,3\n*E\n"})
public final class DiffUtilsKt {
    @Nullable
    public static final Entry findEntry(@NotNull LocalHistoryFacade $this$findEntry, @NotNull RootEntry rootEntry, @NotNull RevisionId revisionId, @NotNull String entryPath, boolean before) {
        Entry entry;
        Intrinsics.checkNotNullParameter((Object)$this$findEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootEntry, (String)"rootEntry");
        Intrinsics.checkNotNullParameter((Object)revisionId, (String)"revisionId");
        Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
        RevisionId revisionId2 = revisionId;
        if (revisionId2 instanceof RevisionId.ChangeSet) {
            RootEntry rootEntry2 = rootEntry.copy();
            Intrinsics.checkNotNullExpressionValue((Object)rootEntry2, (String)"copy(...)");
            RootEntry rootCopy = rootEntry2;
            String entryPathInChangeSet = $this$findEntry.revertUpToChangeSet(rootCopy, ((RevisionId.ChangeSet)revisionId).getId(), entryPath, before, true);
            entry = rootCopy.findEntry(entryPathInChangeSet);
        } else if (Intrinsics.areEqual((Object)revisionId2, (Object)RevisionId.Current.INSTANCE)) {
            entry = rootEntry.findEntry(entryPath);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return entry;
    }

    @NotNull
    public static final Difference getSingleFileDiff(@NotNull LocalHistoryFacade $this$getSingleFileDiff, @NotNull RootEntry rootEntry, @NotNull ChangeSetSelection selection, @NotNull String entryPath, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$getSingleFileDiff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootEntry, (String)"rootEntry");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
        Entry leftEntry = DiffUtilsKt.findEntry($this$getSingleFileDiff, rootEntry, ChangeSetSelectionKt.getLeftRevision(selection), entryPath, isOldContentUsed);
        Entry rightEntry = DiffUtilsKt.findEntry($this$getSingleFileDiff, rootEntry, ChangeSetSelectionKt.getRightRevision(selection), entryPath, isOldContentUsed);
        return new Difference(leftEntry, rightEntry, ChangeSetSelectionKt.getRightRevision(selection) instanceof RevisionId.Current);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Difference> getDiff(@NotNull LocalHistoryFacade $this$getDiff, @NotNull RootEntry rootEntry, @NotNull ChangeSetSelection selection, @NotNull Collection<String> entryPaths, @NotNull DirectoryDiffMode diffMode, boolean isOldContentUsed) {
        void $this$flatMapTo$iv$iv;
        Object rightItem;
        Intrinsics.checkNotNullParameter((Object)$this$getDiff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootEntry, (String)"rootEntry");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter(entryPaths, (String)"entryPaths");
        Intrinsics.checkNotNullParameter((Object)((Object)diffMode), (String)"diffMode");
        RevisionId leftRevision = ChangeSetSelectionKt.getLeftRevision(selection);
        RevisionId rightRevision = switch (WhenMappings.$EnumSwitchMapping$0[diffMode.ordinal()]) {
            case 1 -> ChangeSetSelectionKt.getRightRevision(selection);
            case 2 -> {
                rightItem = selection.getRightItem();
                if (rightItem != null) {
                    yield new RevisionId.ChangeSet(((ChangeSetActivityItem)rightItem).getId());
                }
                yield DiffUtilsKt.nextRevision($this$getDiff, leftRevision);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Iterable $this$flatMap$iv = entryPaths;
        boolean $i$f$flatMap = false;
        rightItem = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Entry leftEntry = DiffUtilsKt.findEntry($this$getDiff, rootEntry, leftRevision, it, isOldContentUsed);
            Entry rightEntry = DiffUtilsKt.findEntry($this$getDiff, rootEntry, rightRevision, it, isOldContentUsed);
            List<Difference> list = Entry.getDifferencesBetween(leftEntry, rightEntry, rightRevision instanceof RevisionId.Current);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDifferencesBetween(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final RevisionId nextRevision(LocalHistoryFacade $this$nextRevision, RevisionId revisionId) {
        RevisionId revisionId2;
        if (revisionId instanceof RevisionId.Current) {
            return RevisionId.Current.INSTANCE;
        }
        Intrinsics.checkNotNull((Object)revisionId, (String)"null cannot be cast to non-null type com.intellij.platform.lvcs.impl.RevisionId.ChangeSet");
        RevisionId.ChangeSet cfr_ignored_0 = (RevisionId.ChangeSet)revisionId;
        Long nextChange = null;
        for (ChangeSet change : $this$nextRevision.getChanges$intellij_platform_lvcs_impl()) {
            if (change.getId() == ((RevisionId.ChangeSet)revisionId).getId()) break;
            nextChange = change.getId();
        }
        Long l = nextChange;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            revisionId2 = new RevisionId.ChangeSet(it);
        } else {
            revisionId2 = RevisionId.Current.INSTANCE;
        }
        return revisionId2;
    }

    @NotNull
    public static final List<Difference> getDiff(@NotNull LocalHistoryFacade $this$getDiff, @NotNull IdeaGateway gateway, @NotNull ActivityScope scope, @NotNull ChangeSetSelection selection, @NotNull DirectoryDiffMode diffMode, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$getDiff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)((Object)diffMode), (String)"diffMode");
        RootEntry rootEntry = LocalHistoryActivityDataKt.getRootEntry(selection.getData(), gateway);
        Collection<String> entryPaths = DiffUtilsKt.getEntryPaths(gateway, scope);
        return CollectionsKt.toList((Iterable)DiffUtilsKt.getDiff($this$getDiff, rootEntry, selection, entryPaths, diffMode, isOldContentUsed));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<String> getEntryPaths(@NotNull IdeaGateway gateway, @NotNull ActivityScope scope) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ActivityScope activityScope = scope;
        if (activityScope instanceof ActivityScope.File) {
            collection = CollectionsKt.listOf((Object)DiffUtilsKt.getEntryPath(gateway, (ActivityScope.File)scope));
        } else if (activityScope instanceof ActivityScope.Files) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((ActivityScope.Files)scope).getFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(gateway.getPathOrUrl((VirtualFile)it));
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.listOf((Object)"");
        }
        return collection;
    }

    @NotNull
    public static final String getEntryPath(@NotNull IdeaGateway gateway, @NotNull ActivityScope.File scope) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String string = gateway.getPathOrUrl(scope.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathOrUrl(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirectoryDiffMode.values().length];
            try {
                nArray[DirectoryDiffMode.WithLocal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirectoryDiffMode.WithNext.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

