\name{BinaryImageToLabelMapFilter}
\alias{BinaryImageToLabelMapFilter}
\title{BinaryImageToLabelMapFilter}
\Rdversion{1.1}
\docType{class}
\description{
Label the connected components in a binary image and produce a collection
of label objects.
BinaryImageToLabelMapFilter}
\details{
BinaryImageToLabelMapFilter labels the objects in a binary image. Each distinct object is
assigned a unique label. The final object labels start with 1 and are
consecutive. Objects that are reached earlier by a raster order scan
have a lower label.
The GetOutput() function of this class returns an itk::LabelMap .
This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ConnectedComponentImageFilter , LabelImageToLabelMapFilter , LabelMap , LabelObject
BinaryImageToLabelMapFilter for the procedural interface
itk::BinaryImageToLabelMapFilter for the Doxygen on the original ITK class.
BinaryImageToLabelMapFilter}
%C++ includes: sitkBinaryImageToLabelMapFilter.h
\section{Methods}{
\describe{
\item{ BinaryImageToLabelMapFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{double GetInputForegroundValue() const:}{
Set/Get the value to be consider "foreground" in the input image.
Defaults to NumericTraits<InputPixelType>::max() .
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint64_t GetNumberOfObjects() const:}{
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetOutputBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<OutputPixelType>::NonpositiveMin() .
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetInputForegroundValue(double InputForegroundValue):}{
Set/Get the value to be consider "foreground" in the input image.
Defaults to NumericTraits<InputPixelType>::max() .
}
\item{Self SetOutputBackgroundValue(double OutputBackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<OutputPixelType>::NonpositiveMin() .
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryImageToLabelMapFilter():}{
Destructor
}
}
}
